/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class DevMode {
    private static boolean enabled = false;
    private static final Map<UUID, UUID> fakeIdentities = new HashMap<UUID, UUID>();
    private static final Map<UUID, String> fakeNames = new HashMap<UUID, String>();
    public static final UUID PLAYER_A = UUID.fromString("00000000-0000-0000-0000-000000000001");
    public static final UUID PLAYER_B = UUID.fromString("00000000-0000-0000-0000-000000000002");
    public static final UUID PLAYER_C = UUID.fromString("00000000-0000-0000-0000-000000000003");

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        DevMode.enabled = enabled;
        if (!enabled) {
            fakeIdentities.clear();
            fakeNames.clear();
        }
    }

    public static void setIdentity(Player player, String identity) {
        UUID realUuid = player.getUniqueId();
        switch (identity.toLowerCase()) {
            case "a": {
                fakeIdentities.put(realUuid, PLAYER_A);
                fakeNames.put(realUuid, "TestPlayer_A");
                break;
            }
            case "b": {
                fakeIdentities.put(realUuid, PLAYER_B);
                fakeNames.put(realUuid, "TestPlayer_B");
                break;
            }
            case "c": {
                fakeIdentities.put(realUuid, PLAYER_C);
                fakeNames.put(realUuid, "TestPlayer_C");
                break;
            }
            default: {
                fakeIdentities.remove(realUuid);
                fakeNames.remove(realUuid);
            }
        }
    }

    public static UUID getEffectiveUUID(Player player) {
        if (!enabled) {
            return player.getUniqueId();
        }
        return fakeIdentities.getOrDefault(player.getUniqueId(), player.getUniqueId());
    }

    public static String getEffectiveName(Player player) {
        if (!enabled) {
            return player.getName();
        }
        return fakeNames.getOrDefault(player.getUniqueId(), player.getName());
    }

    public static String getCurrentIdentityLabel(Player player) {
        if (!enabled) {
            return "Dev mode disabled";
        }
        UUID fakeUuid = fakeIdentities.get(player.getUniqueId());
        if (fakeUuid == null) {
            return "Your real identity";
        }
        if (fakeUuid.equals(PLAYER_A)) {
            return "TestPlayer_A";
        }
        if (fakeUuid.equals(PLAYER_B)) {
            return "TestPlayer_B";
        }
        if (fakeUuid.equals(PLAYER_C)) {
            return "TestPlayer_C";
        }
        return "Unknown";
    }
}

