/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.data;

import com.elfahja.chesttrade.ChestTrade;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class TradeChestRegistry {
    private static TradeChestRegistry instance;
    private final File dataFile;
    private YamlConfiguration data;
    private final Map<String, ChestData> chests = new HashMap<String, ChestData>();
    private final Map<UUID, Long> lastLoginTimes = new HashMap<UUID, Long>();
    private final Set<UUID> jailedPlayers = new HashSet<UUID>();

    public static TradeChestRegistry getInstance() {
        if (instance == null) {
            instance = new TradeChestRegistry();
        }
        return instance;
    }

    private TradeChestRegistry() {
        this.dataFile = new File(ChestTrade.getInstance().getDataFolder(), "data.yml");
        this.load();
    }

    public void load() {
        if (!this.dataFile.exists()) {
            this.data = new YamlConfiguration();
            return;
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.chests.clear();
        ConfigurationSection chestsSection = this.data.getConfigurationSection("chests");
        if (chestsSection != null) {
            for (Object key : chestsSection.getKeys(false)) {
                String ownerStr;
                ConfigurationSection chestData = chestsSection.getConfigurationSection((String)key);
                if (chestData == null || (ownerStr = chestData.getString("owner")) == null) continue;
                ChestData cd = new ChestData(UUID.fromString(ownerStr), chestData.getString("owner-name", "Unknown"), chestData.getInt("tier", 1), chestData.getLong("created", System.currentTimeMillis()));
                this.chests.put((String)key, cd);
            }
        }
        this.lastLoginTimes.clear();
        ConfigurationSection loginsSection = this.data.getConfigurationSection("last-logins");
        if (loginsSection != null) {
            for (String uuidStr : loginsSection.getKeys(false)) {
                this.lastLoginTimes.put(UUID.fromString(uuidStr), loginsSection.getLong(uuidStr));
            }
        }
        this.jailedPlayers.clear();
        List jailedList = this.data.getStringList("jailed-players");
        for (String uuidStr : jailedList) {
            this.jailedPlayers.add(UUID.fromString(uuidStr));
        }
        ChestTrade.getInstance().getLogger().info("Loaded " + this.chests.size() + " Trade Chests from registry");
    }

    public void save() {
        this.data.set("chests", null);
        for (Map.Entry<String, ChestData> entry : this.chests.entrySet()) {
            String path = "chests." + entry.getKey();
            ChestData cd = entry.getValue();
            this.data.set(path + ".owner", (Object)cd.owner.toString());
            this.data.set(path + ".owner-name", (Object)cd.ownerName);
            this.data.set(path + ".tier", (Object)cd.tier);
            this.data.set(path + ".created", (Object)cd.created);
        }
        this.data.set("last-logins", null);
        for (Map.Entry<Object, Object> entry : this.lastLoginTimes.entrySet()) {
            this.data.set("last-logins." + ((UUID)entry.getKey()).toString(), entry.getValue());
        }
        ArrayList<String> jailedList = new ArrayList<String>();
        for (UUID uuid : this.jailedPlayers) {
            jailedList.add(uuid.toString());
        }
        this.data.set("jailed-players", jailedList);
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException iOException) {
            ChestTrade.getInstance().getLogger().severe("Failed to save Trade Chest registry: " + iOException.getMessage());
        }
    }

    public void register(Location location, UUID owner, String ownerName, int tier) {
        String key = this.locationToKey(location);
        this.chests.put(key, new ChestData(owner, ownerName, tier, System.currentTimeMillis()));
        this.save();
    }

    public void unregister(Location location) {
        String key = this.locationToKey(location);
        if (this.chests.remove(key) != null) {
            this.save();
        }
    }

    public boolean isRegistered(Location location) {
        return this.chests.containsKey(this.locationToKey(location));
    }

    public ChestData getChestData(Location location) {
        return this.chests.get(this.locationToKey(location));
    }

    public int countPlayerChests(UUID owner) {
        int count = 0;
        for (ChestData cd : this.chests.values()) {
            if (!cd.owner.equals(owner)) continue;
            ++count;
        }
        return count;
    }

    public List<Location> getPlayerChests(UUID owner) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (Map.Entry<String, ChestData> entry : this.chests.entrySet()) {
            Location loc;
            if (!entry.getValue().owner.equals(owner) || (loc = this.keyToLocation(entry.getKey())) == null) continue;
            locations.add(loc);
        }
        return locations;
    }

    public void updateLastLogin(UUID player) {
        this.lastLoginTimes.put(player, System.currentTimeMillis());
        this.save();
    }

    public long getLastLogin(UUID player) {
        return this.lastLoginTimes.getOrDefault(player, System.currentTimeMillis());
    }

    public void setLastLoginForTesting(UUID player, long time) {
        this.lastLoginTimes.put(player, time);
        this.save();
    }

    public boolean isAbandoned(Location location) {
        if (!ChestTrade.getInstance().getConfig().getBoolean("abandonment.enabled", false)) {
            return false;
        }
        ChestData cd = this.getChestData(location);
        if (cd == null) {
            return false;
        }
        int days = ChestTrade.getInstance().getConfig().getInt("abandonment.days", 30);
        long thresholdMs = (long)days * 24L * 60L * 60L * 1000L;
        long lastLogin = this.getLastLogin(cd.owner);
        return System.currentTimeMillis() - lastLogin > thresholdMs;
    }

    public int getDaysUntilAbandonment(Location location) {
        if (!ChestTrade.getInstance().getConfig().getBoolean("abandonment.enabled", false)) {
            return -1;
        }
        ChestData cd = this.getChestData(location);
        if (cd == null) {
            return -1;
        }
        int days = ChestTrade.getInstance().getConfig().getInt("abandonment.days", 30);
        long thresholdMs = (long)days * 24L * 60L * 60L * 1000L;
        long lastLogin = this.getLastLogin(cd.owner);
        long elapsed = System.currentTimeMillis() - lastLogin;
        long remaining = thresholdMs - elapsed;
        if (remaining <= 0L) {
            return 0;
        }
        return (int)(remaining / 86400000L) + 1;
    }

    private String locationToKey(Location loc) {
        return loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
    }

    private Location keyToLocation(String key) {
        String[] parts = key.split(":");
        if (parts.length != 4) {
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return new Location(world, (double)x, (double)y, (double)z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public List<Map.Entry<Location, ChestData>> getAllChests() {
        ArrayList<Map.Entry<Location, ChestData>> result = new ArrayList<Map.Entry<Location, ChestData>>();
        for (Map.Entry<String, ChestData> entry : this.chests.entrySet()) {
            Location loc = this.keyToLocation(entry.getKey());
            if (loc == null) continue;
            result.add(new AbstractMap.SimpleEntry<Location, ChestData>(loc, entry.getValue()));
        }
        return result;
    }

    public int cleanup() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : this.chests.keySet()) {
            Block block;
            Material type;
            Location loc = this.keyToLocation(key);
            if (loc == null) {
                toRemove.add(key);
                continue;
            }
            if (loc.getWorld() == null || (type = (block = loc.getBlock()).getType()) == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL) continue;
            toRemove.add(key);
        }
        for (String key : toRemove) {
            this.chests.remove(key);
        }
        if (!toRemove.isEmpty()) {
            this.save();
        }
        return toRemove.size();
    }

    public void jail(UUID player) {
        this.jailedPlayers.add(player);
        this.save();
    }

    public void unjail(UUID player) {
        this.jailedPlayers.remove(player);
        this.save();
    }

    public boolean isJailed(UUID player) {
        return this.jailedPlayers.contains(player);
    }

    public int getJailedCount() {
        return this.jailedPlayers.size();
    }

    public static class ChestData {
        public final UUID owner;
        public final String ownerName;
        public final int tier;
        public final long created;

        public ChestData(UUID owner, String ownerName, int tier, long created) {
            this.owner = owner;
            this.ownerName = ownerName;
            this.tier = tier;
            this.created = created;
        }
    }
}

