/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.items;

import com.elfahja.chesttrade.ChestTrade;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class TradabilityBookItem {
    public static final NamespacedKey KEY_TRADABILITY_TIER = new NamespacedKey("chesttrade", "tradability_tier");
    private static final String[] TIER_NUMERALS = new String[]{"I", "II", "III", "IV", "V"};
    private static final NamedTextColor[] TIER_COLORS = new NamedTextColor[]{NamedTextColor.WHITE, NamedTextColor.GREEN, NamedTextColor.AQUA, NamedTextColor.LIGHT_PURPLE, NamedTextColor.GOLD};

    public static ItemStack create(int tier) {
        tier = Math.max(1, Math.min(5, tier));
        ItemStack item = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = item.getItemMeta();
        String numeral = TIER_NUMERALS[tier - 1];
        NamedTextColor color = TIER_COLORS[tier - 1];
        meta.displayName(((TextComponent)Component.text((String)("Tradability " + numeral)).color((TextColor)color)).decoration(TextDecoration.ITALIC, false));
        meta.lore(TradabilityBookItem.createLore(tier));
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(KEY_TRADABILITY_TIER, PersistentDataType.INTEGER, (Object)tier);
        item.setItemMeta(meta);
        return item;
    }

    private static List<Component> createLore(int tier) {
        Component description = ((TextComponent)Component.text((String)"Used to craft Trade Chests").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false);
        int density = ChestTrade.getInstance().getConfig().getInt("density.tier-" + tier, 0);
        String densityText = density == 0 ? "unlimited" : String.valueOf(density) + " per area";
        TextComponent tierInfo = switch (tier) {
            case 1 -> (TextComponent)((TextComponent)Component.text((String)("Single chest, " + densityText)).color((TextColor)NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false);
            case 2 -> (TextComponent)((TextComponent)Component.text((String)("+ Barrels, Trapped chests, " + densityText)).color((TextColor)NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false);
            case 3 -> (TextComponent)((TextComponent)Component.text((String)("+ Double chests, " + densityText)).color((TextColor)NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false);
            case 4 -> (TextComponent)((TextComponent)Component.text((String)("+ Sell bundles, " + densityText)).color((TextColor)NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false);
            case 5 -> (TextComponent)((TextComponent)Component.text((String)("+ Sell shulkers, " + densityText)).color((TextColor)NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false);
            default -> Component.empty();
        };
        return List.of(description, tierInfo);
    }

    public static boolean isTradabilityBook(ItemStack item) {
        if (item == null || item.getType() != Material.ENCHANTED_BOOK) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return pdc.has(KEY_TRADABILITY_TIER, PersistentDataType.INTEGER);
    }

    public static int getTier(ItemStack item) {
        if (!TradabilityBookItem.isTradabilityBook(item)) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        Integer tier = (Integer)pdc.get(KEY_TRADABILITY_TIER, PersistentDataType.INTEGER);
        return tier != null ? tier : 0;
    }
}

