/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.items;

import com.elfahja.chesttrade.ChestTrade;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class TradeChestItem {
    public static final NamespacedKey KEY_IS_TRADE_CHEST = new NamespacedKey("chesttrade", "is_trade_chest");
    public static final NamespacedKey KEY_TIER = new NamespacedKey("chesttrade", "tier");
    public static final NamespacedKey KEY_TRADES = new NamespacedKey("chesttrade", "trades");
    private static final Set<Material> VALID_CONTAINERS = Set.of(Material.CHEST, Material.TRAPPED_CHEST, Material.BARREL);
    private static final String[] TIER_NUMERALS = new String[]{"I", "II", "III", "IV", "V"};
    private static final NamedTextColor[] TIER_COLORS = new NamedTextColor[]{NamedTextColor.WHITE, NamedTextColor.GREEN, NamedTextColor.AQUA, NamedTextColor.LIGHT_PURPLE, NamedTextColor.GOLD};

    public static ItemStack create() {
        return TradeChestItem.create(Material.CHEST, 5);
    }

    public static ItemStack create(int tier) {
        return TradeChestItem.create(Material.CHEST, tier);
    }

    public static ItemStack create(Material containerType, int tier) {
        if (!VALID_CONTAINERS.contains(containerType)) {
            containerType = Material.CHEST;
        }
        tier = Math.max(1, Math.min(5, tier));
        ItemStack item = new ItemStack(containerType);
        ItemMeta meta = item.getItemMeta();
        String numeral = TIER_NUMERALS[tier - 1];
        NamedTextColor tierColor = TIER_COLORS[tier - 1];
        String containerName = TradeChestItem.getContainerName(containerType);
        meta.displayName(((TextComponent)((TextComponent)Component.text((String)("Trade " + containerName + " ")).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false)).append(((TextComponent)Component.text((String)("[" + numeral + "]")).color((TextColor)tierColor)).decoration(TextDecoration.ITALIC, false)));
        meta.lore(List.of(((TextComponent)Component.text((String)("A " + containerName.toLowerCase() + " for trading")).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false), Component.empty(), TradeChestItem.getTierDescription(tier)));
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(KEY_IS_TRADE_CHEST, PersistentDataType.BOOLEAN, (Object)true);
        pdc.set(KEY_TIER, PersistentDataType.INTEGER, (Object)tier);
        pdc.set(KEY_TRADES, PersistentDataType.INTEGER, (Object)0);
        item.setItemMeta(meta);
        return item;
    }

    public static boolean isTradeChest(ItemStack item) {
        if (item == null || !VALID_CONTAINERS.contains(item.getType())) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        return pdc.has(KEY_IS_TRADE_CHEST, PersistentDataType.BOOLEAN);
    }

    public static boolean isValidContainer(Material material) {
        return VALID_CONTAINERS.contains(material);
    }

    public static int getTier(ItemStack item) {
        if (!TradeChestItem.isTradeChest(item)) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        Integer tier = (Integer)pdc.get(KEY_TIER, PersistentDataType.INTEGER);
        return tier != null ? tier : 5;
    }

    public static int getMinTierForContainer(Material containerType) {
        return switch (containerType) {
            case Material.CHEST -> 1;
            case Material.TRAPPED_CHEST, Material.BARREL -> 2;
            default -> 1;
        };
    }

    private static String getContainerName(Material material) {
        return switch (material) {
            case Material.CHEST -> "Chest";
            case Material.TRAPPED_CHEST -> "Trapped Chest";
            case Material.BARREL -> "Barrel";
            default -> "Chest";
        };
    }

    private static Component getTierDescription(int tier) {
        int density = ChestTrade.getInstance().getConfig().getInt("density.tier-" + tier, 0);
        String densityText = density == 0 ? "unlimited" : String.valueOf(density) + " per area";
        Object desc = switch (tier) {
            case 1 -> "Single chest, " + densityText;
            case 2 -> "+ Barrels, Trapped chests, " + densityText;
            case 3 -> "+ Double chests, " + densityText;
            case 4 -> "+ Sell bundles, " + densityText;
            case 5 -> "+ Sell shulkers, " + densityText;
            default -> "Unknown";
        };
        return ((TextComponent)Component.text((String)desc).color((TextColor)NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false);
    }
}

