/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.listeners;

import com.elfahja.chesttrade.ChestTrade;
import com.elfahja.chesttrade.data.TradeChestRegistry;
import com.elfahja.chesttrade.items.TradabilityBookItem;
import com.elfahja.chesttrade.listeners.TradeChestListener;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.TileState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerLoginListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        TradeChestRegistry.getInstance().updateLastLogin(player.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)ChestTrade.getInstance(), () -> this.showTradeNotifications(player), 60L);
    }

    private void showTradeNotifications(Player player) {
        List<Location> chestLocations = TradeChestRegistry.getInstance().getPlayerChests(player.getUniqueId());
        if (chestLocations.isEmpty()) {
            return;
        }
        int totalNewTrades = 0;
        int totalNewXp = 0;
        int chestsWithRewards = 0;
        int totalRewardBooks = 0;
        for (Location loc : chestLocations) {
            int rewardSlot;
            ItemStack rewardItem;
            Inventory inv;
            BlockState blockState;
            Block block = loc.getBlock();
            Material type = block.getType();
            if (type != Material.CHEST && type != Material.TRAPPED_CHEST && type != Material.BARREL || !((blockState = block.getState()) instanceof TileState)) continue;
            TileState tileState = (TileState)blockState;
            PersistentDataContainer pdc = tileState.getPersistentDataContainer();
            int currentTrades = (Integer)pdc.getOrDefault(TradeChestListener.KEY_TRADES, PersistentDataType.INTEGER, (Object)0);
            int currentXp = (Integer)pdc.getOrDefault(TradeChestListener.KEY_XP, PersistentDataType.INTEGER, (Object)0);
            int notifiedTrades = (Integer)pdc.getOrDefault(TradeChestListener.KEY_TRADES_NOTIFIED, PersistentDataType.INTEGER, (Object)0);
            int notifiedXp = (Integer)pdc.getOrDefault(TradeChestListener.KEY_XP_NOTIFIED, PersistentDataType.INTEGER, (Object)0);
            int newTrades = currentTrades - notifiedTrades;
            int newXp = currentXp - notifiedXp;
            if (newTrades > 0) {
                totalNewTrades += newTrades;
            }
            if (newXp > 0) {
                totalNewXp += newXp;
            }
            if ((inv = this.getBlockInventory(block)) != null && (rewardItem = inv.getItem(rewardSlot = inv.getSize() == 54 ? 53 : 26)) != null && TradabilityBookItem.isTradabilityBook(rewardItem)) {
                ++chestsWithRewards;
                totalRewardBooks += rewardItem.getAmount();
            }
            pdc.set(TradeChestListener.KEY_TRADES_NOTIFIED, PersistentDataType.INTEGER, (Object)currentTrades);
            pdc.set(TradeChestListener.KEY_XP_NOTIFIED, PersistentDataType.INTEGER, (Object)currentXp);
            tileState.update();
        }
        if (totalNewTrades == 0 && totalNewXp == 0 && chestsWithRewards == 0) {
            return;
        }
        player.sendMessage((Component)Component.text((String)""));
        player.sendMessage((Component)Component.text((String)"=== Trade Activity Summary ===", (TextColor)NamedTextColor.GOLD));
        if (totalNewTrades > 0) {
            String tradeWord = totalNewTrades == 1 ? "trade" : "trades";
            player.sendMessage(Component.text((String)" \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(totalNewTrades + " " + tradeWord + " completed"), (TextColor)NamedTextColor.GREEN)));
        }
        if (totalNewXp > 0) {
            player.sendMessage(Component.text((String)" \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(totalNewXp + " XP earned"), (TextColor)NamedTextColor.AQUA)));
        }
        if (chestsWithRewards > 0) {
            String bookWord = totalRewardBooks == 1 ? "book" : "books";
            String chestWord = chestsWithRewards == 1 ? "chest" : "chests";
            player.sendMessage(Component.text((String)" \u2022 ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(totalRewardBooks + " reward " + bookWord + " waiting in " + chestsWithRewards + " " + chestWord), (TextColor)NamedTextColor.YELLOW)));
        }
        player.sendMessage((Component)Component.text((String)""));
    }

    private Inventory getBlockInventory(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            return chest.getInventory();
        }
        blockState = block.getState();
        if (blockState instanceof Barrel) {
            Barrel barrel = (Barrel)blockState;
            return barrel.getInventory();
        }
        return null;
    }
}

