/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.listeners;

import com.elfahja.chesttrade.ChestTrade;
import com.elfahja.chesttrade.DevMode;
import com.elfahja.chesttrade.data.TradeChestRegistry;
import com.elfahja.chesttrade.listeners.TradeChestListener;
import com.elfahja.chesttrade.util.ItemValueTier;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.TileState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;

public class TradeChestDisplayTask
extends BukkitRunnable {
    private static final int PRICE_SLOT = 0;
    private static final Set<Material> VALID_CONTAINERS = Set.of(Material.CHEST, Material.TRAPPED_CHEST, Material.BARREL);
    private final Plugin plugin;

    public TradeChestDisplayTask(Plugin plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.runTaskTimer(this.plugin, 0L, 5L);
    }

    public void run() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.checkPlayerLookingAt(player);
        }
    }

    private void checkPlayerLookingAt(Player player) {
        boolean isAbandoned;
        RayTraceResult result = player.rayTraceBlocks(5.0, FluidCollisionMode.NEVER);
        if (result == null || result.getHitBlock() == null) {
            return;
        }
        Block block = result.getHitBlock();
        if (!VALID_CONTAINERS.contains(block.getType())) {
            return;
        }
        if (!TradeChestListener.isTradeChest(block)) {
            return;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof TileState)) {
            return;
        }
        TileState tileState = (TileState)blockState;
        String ownerName = (String)tileState.getPersistentDataContainer().get(TradeChestListener.KEY_OWNER_NAME, PersistentDataType.STRING);
        Integer tier = (Integer)tileState.getPersistentDataContainer().get(TradeChestListener.KEY_TIER, PersistentDataType.INTEGER);
        UUID ownerUuid = TradeChestListener.getOwner(block);
        UUID playerUuid = DevMode.getEffectiveUUID(player);
        boolean isOwner = ownerUuid != null && ownerUuid.equals(playerUuid);
        boolean bl = isAbandoned = !isOwner && TradeChestRegistry.getInstance().isAbandoned(block.getLocation());
        if (isAbandoned) {
            String tierNumeral = this.getTierNumeral(tier != null ? tier : 5);
            Component message = ((TextComponent)((TextComponent)Component.text((String)(ownerName + "'s "), (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)("[" + tierNumeral + "] "), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"ABANDONED", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" - Break to claim!", (TextColor)NamedTextColor.YELLOW));
            player.sendActionBar(message);
            return;
        }
        Inventory containerInv = this.getInventory(block);
        if (containerInv == null) {
            return;
        }
        ItemStack priceItem = containerInv.getItem(0);
        boolean isSoldOut = this.checkSoldOut(containerInv, priceItem);
        Integer currentXp = null;
        Integer xpThreshold = null;
        if (isOwner && this.isXpEnabled()) {
            PersistentDataContainer pdc = tileState.getPersistentDataContainer();
            currentXp = (Integer)pdc.get(TradeChestListener.KEY_XP, PersistentDataType.INTEGER);
            if (currentXp == null) {
                currentXp = 0;
            }
            xpThreshold = ItemValueTier.getXpThreshold(tier != null ? tier : 1);
        }
        String containerName = this.getContainerName(block.getType());
        Component message = this.buildActionBarMessage(ownerName, tier, priceItem, isSoldOut, isOwner, containerName, currentXp, xpThreshold);
        player.sendActionBar(message);
    }

    private boolean isXpEnabled() {
        String mode = ChestTrade.getInstance().getConfig().getString("mode", "simple");
        if ("simple".equalsIgnoreCase(mode)) {
            return false;
        }
        return ChestTrade.getInstance().getConfig().getBoolean("experience.enabled", true);
    }

    private Inventory getInventory(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            return chest.getInventory();
        }
        blockState = block.getState();
        if (blockState instanceof Barrel) {
            Barrel barrel = (Barrel)blockState;
            return barrel.getInventory();
        }
        return null;
    }

    private String getContainerName(Material material) {
        return switch (material) {
            case Material.CHEST -> "Chest";
            case Material.TRAPPED_CHEST -> "Trapped Chest";
            case Material.BARREL -> "Barrel";
            default -> "Chest";
        };
    }

    private boolean checkSoldOut(Inventory inv, ItemStack priceItem) {
        if (priceItem == null || priceItem.getType().isAir()) {
            return true;
        }
        Material priceType = priceItem.getType();
        for (int i = 1; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null || item.getType().isAir() || item.getType() == priceType) continue;
            return false;
        }
        return true;
    }

    private Component buildActionBarMessage(String ownerName, Integer tier, ItemStack priceItem, boolean isSoldOut, boolean isOwner, String containerName, Integer currentXp, Integer xpThreshold) {
        Component message;
        String tierNumeral = this.getTierNumeral(tier != null ? tier : 5);
        if (isOwner) {
            message = Component.text((String)("Your Trade " + containerName + " "), (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)("[" + tierNumeral + "]"), (TextColor)NamedTextColor.GRAY));
            if (currentXp != null && xpThreshold != null) {
                message = message.append((Component)Component.text((String)" - XP: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)(currentXp + "/" + xpThreshold), (TextColor)NamedTextColor.LIGHT_PURPLE));
            }
        } else {
            message = Component.text((String)(ownerName + "'s Trade " + containerName + " "), (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)("[" + tierNumeral + "]"), (TextColor)NamedTextColor.GRAY));
            message = isSoldOut ? message.append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"SOLD OUT", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})) : message.append((Component)Component.text((String)" - Price: ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)(priceItem.getAmount() + "x " + this.formatMaterial(priceItem.getType())), (TextColor)NamedTextColor.YELLOW));
        }
        return message;
    }

    private String getTierNumeral(int tier) {
        return switch (tier) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(tier);
        };
    }

    private String formatMaterial(Material material) {
        String name = material.name().toLowerCase().replace('_', ' ');
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                result.append(c);
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

