/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.util;

import java.util.Set;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public final class ItemValidator {
    private static final Set<Material> COMPLEX_MATERIALS = Set.of(Material.BUNDLE, Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION, Material.TIPPED_ARROW, Material.WRITTEN_BOOK, Material.WRITABLE_BOOK, Material.FILLED_MAP, Material.FIREWORK_ROCKET, Material.FIREWORK_STAR, Material.SUSPICIOUS_STEW, Material.PLAYER_HEAD, Material.DECORATED_POT, Material.SHIELD, Material.CROSSBOW, Material.KNOWLEDGE_BOOK, Material.GOAT_HORN);
    private static final Set<Material> SHULKER_BOXES = Set.of(Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX);
    private static final Set<Material> BANNERS = Set.of(Material.WHITE_BANNER, Material.ORANGE_BANNER, Material.MAGENTA_BANNER, Material.LIGHT_BLUE_BANNER, Material.YELLOW_BANNER, Material.LIME_BANNER, Material.PINK_BANNER, Material.GRAY_BANNER, Material.LIGHT_GRAY_BANNER, Material.CYAN_BANNER, Material.PURPLE_BANNER, Material.BLUE_BANNER, Material.BROWN_BANNER, Material.GREEN_BANNER, Material.RED_BANNER, Material.BLACK_BANNER);

    private ItemValidator() {
    }

    public static String validatePriceSlot(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return null;
        }
        Material type = item.getType();
        if (COMPLEX_MATERIALS.contains(type)) {
            return "This item cannot be used as payment (has variable data).";
        }
        if (SHULKER_BOXES.contains(type)) {
            return "Shulker boxes cannot be used as payment.";
        }
        if (BANNERS.contains(type)) {
            return "Banners cannot be used as payment.";
        }
        if (item.hasItemMeta()) {
            EnchantmentStorageMeta esm;
            ItemMeta meta = item.getItemMeta();
            if (meta.hasEnchants()) {
                return "Enchanted items cannot be used as payment.";
            }
            if (meta.hasDisplayName()) {
                return "Items with custom names cannot be used as payment.";
            }
            if (meta.hasLore()) {
                return "Items with custom lore cannot be used as payment.";
            }
            if (meta instanceof EnchantmentStorageMeta && (esm = (EnchantmentStorageMeta)meta).hasStoredEnchants()) {
                return "Enchanted books cannot be used as payment.";
            }
        }
        return null;
    }

    public static String validateSaleSlot(ItemStack item, int tier) {
        if (item == null || item.getType().isAir()) {
            return null;
        }
        Material type = item.getType();
        if (type == Material.BUNDLE && tier < 4) {
            return "Selling bundles requires a Tier IV or higher Trade Chest.";
        }
        if (SHULKER_BOXES.contains(type) && tier < 5) {
            return "Selling shulker boxes requires a Tier V Trade Chest.";
        }
        return null;
    }

    public static boolean isShulkerBox(Material material) {
        return SHULKER_BOXES.contains(material);
    }

    public static boolean isBundle(Material material) {
        return material == Material.BUNDLE;
    }
}

