/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.util;

import com.elfahja.chesttrade.ChestTrade;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ToastNotification {
    public static void show(Player player, Material icon, String title, String description, Frame frame) {
        NamespacedKey key = new NamespacedKey((Plugin)ChestTrade.getInstance(), "toast_" + UUID.randomUUID().toString().replace("-", ""));
        String json = ToastNotification.buildAdvancementJson(icon, title, description, frame);
        try {
            Bukkit.getUnsafe().loadAdvancement(key, json);
            Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
            if (advancement != null) {
                AdvancementProgress progress = player.getAdvancementProgress(advancement);
                for (String criteria : progress.getRemainingCriteria()) {
                    progress.awardCriteria(criteria);
                }
                Bukkit.getScheduler().runTaskLater((Plugin)ChestTrade.getInstance(), () -> {
                    try {
                        for (String criteria : progress.getAwardedCriteria()) {
                            progress.revokeCriteria(criteria);
                        }
                        Bukkit.getUnsafe().removeAdvancement(key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, 100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showBookEarned(Player player, int bookTier) {
        String tierName = ToastNotification.toRoman(bookTier);
        ToastNotification.show(player, Material.ENCHANTED_BOOK, "Tradability " + tierName + " Earned!", "Check your Trade Chest", Frame.GOAL);
    }

    public static void showTradeCompleted(Player player, Material item, int amount) {
        ToastNotification.show(player, item, amount + "x " + ToastNotification.formatMaterial(item) + " Earned!", "Trade completed", Frame.GOAL);
    }

    private static String formatMaterial(Material material) {
        String name = material.name().toLowerCase().replace('_', ' ');
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                result.append(c);
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static String buildAdvancementJson(Material icon, String title, String description, Frame frame) {
        String iconId = "minecraft:" + icon.name().toLowerCase();
        String frameStr = frame.name().toLowerCase();
        title = ToastNotification.escapeJson(title);
        description = ToastNotification.escapeJson(description);
        return "{\n    \"parent\": \"minecraft:recipes/root\",\n    \"criteria\": {\n        \"trigger\": {\n            \"trigger\": \"minecraft:impossible\"\n        }\n    },\n    \"display\": {\n        \"icon\": {\n            \"id\": \"%s\"\n        },\n        \"title\": \"%s\",\n        \"description\": \"%s\",\n        \"frame\": \"%s\",\n        \"show_toast\": true,\n        \"announce_to_chat\": false,\n        \"hidden\": false\n    }\n}\n".formatted(iconId, title, description, frameStr);
    }

    private static String escapeJson(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static String toRoman(int tier) {
        return switch (tier) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(tier);
        };
    }

    public static enum Frame {
        TASK,
        GOAL,
        CHALLENGE;

    }
}

