/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.enhancedRails;

import com.elfahja.enhancedRails.EnhancedRails;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Rail;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MinecartLoader
implements Listener {
    private final EnhancedRails plugin;

    public MinecartLoader(EnhancedRails plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof HopperMinecart)) {
            return;
        }
        HopperMinecart hopperMinecart = (HopperMinecart)vehicle;
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("minecart-loader.enabled", true)) {
            return;
        }
        this.processMinecart(hopperMinecart);
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        if (!this.plugin.getConfig().getBoolean("minecart-loader.enabled", true)) {
            return;
        }
        InventoryHolder source = event.getSource().getHolder();
        InventoryHolder destination = event.getDestination().getHolder();
        if (source instanceof HopperMinecart) {
            final HopperMinecart hopperMinecart = (HopperMinecart)source;
            new BukkitRunnable(){

                public void run() {
                    MinecartLoader.this.processMinecart(hopperMinecart);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        } else if (destination instanceof HopperMinecart) {
            final HopperMinecart hopperMinecart = (HopperMinecart)destination;
            new BukkitRunnable(){

                public void run() {
                    MinecartLoader.this.processMinecart(hopperMinecart);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    private void processMinecart(HopperMinecart hopperMinecart) {
        Block railBlock = hopperMinecart.getLocation().getBlock();
        if (railBlock.getType() != Material.POWERED_RAIL) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("minecart-loader.debug", false)) {
            this.plugin.getLogger().info("We're on the right block");
        }
        if (!this.isAtRailEnd(railBlock)) {
            return;
        }
        if (!this.checkSpecialBlockRequirement(railBlock)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("minecart-loader.debug", false)) {
            this.plugin.getLogger().info("Special block req passed");
        }
        Block blockBelow = railBlock.getRelative(BlockFace.DOWN);
        Block blockAbove = railBlock.getRelative(BlockFace.UP);
        if (blockBelow.getType() == Material.HOPPER && blockAbove.getType() != Material.HOPPER && blockAbove.getType() != Material.CHEST) {
            this.checkUnloaderConditions(hopperMinecart);
        } else if ((blockAbove.getType() == Material.HOPPER || blockAbove.getType() == Material.CHEST) && blockBelow.getType() != Material.HOPPER && blockBelow.getType() != Material.CHEST) {
            this.checkLoaderConditions(hopperMinecart);
        }
    }

    private boolean isAtRailEnd(Block railBlock) {
        int adjacentRailCount = 0;
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
            Block adjacent = railBlock.getRelative(face);
            if (adjacent.getType() != Material.POWERED_RAIL && adjacent.getType() != Material.RAIL && adjacent.getType() != Material.ACTIVATOR_RAIL && adjacent.getType() != Material.DETECTOR_RAIL) continue;
            ++adjacentRailCount;
        }
        return adjacentRailCount <= 1;
    }

    private boolean checkSpecialBlockRequirement(Block railBlock) {
        if (!this.plugin.getConfig().getBoolean("minecart-loader.special-block.enabled", true)) {
            return true;
        }
        String specialBlockMaterial = this.plugin.getConfig().getString("minecart-loader.special-block.material", "SMOOTH_STONE").toUpperCase();
        Rail rail = (Rail)railBlock.getBlockData();
        Rail.Shape shape = rail.getShape();
        Block endBlock = this.findEndBlock(railBlock, shape);
        if (endBlock != null && this.plugin.getConfig().getBoolean("minecart-loader.debug", false)) {
            this.plugin.getLogger().info("End block found: " + endBlock.getType().name());
        }
        return endBlock != null && endBlock.getType().name().equals(specialBlockMaterial);
    }

    private void checkUnloaderConditions(HopperMinecart hopperMinecart) {
        if (this.isInventoryEmpty(hopperMinecart.getInventory())) {
            this.pushMinecart(hopperMinecart);
        }
    }

    private void checkLoaderConditions(HopperMinecart hopperMinecart) {
        InventoryHolder containerAbove;
        BlockState blockState;
        Block railBlock = hopperMinecart.getLocation().getBlock();
        Block blockAbove = railBlock.getRelative(BlockFace.UP);
        if (this.plugin.getConfig().getBoolean("minecart-loader.debug", false)) {
            this.plugin.getLogger().info("In check loader");
        }
        if (this.isInventoryFull(hopperMinecart.getInventory())) {
            this.pushMinecart(hopperMinecart);
            return;
        }
        if ((blockAbove.getType() == Material.HOPPER || blockAbove.getType() == Material.CHEST) && (blockState = blockAbove.getState()) instanceof InventoryHolder && this.isInventoryEmpty((containerAbove = (InventoryHolder)blockState).getInventory()) && !this.isInventoryEmpty(hopperMinecart.getInventory())) {
            this.pushMinecart(hopperMinecart);
        }
    }

    private Block findEndBlock(Block railBlock, Rail.Shape shape) {
        BlockFace endDirection = null;
        for (BlockFace face : switch (shape) {
            case Rail.Shape.NORTH_SOUTH, Rail.Shape.ASCENDING_NORTH, Rail.Shape.ASCENDING_SOUTH -> new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH};
            case Rail.Shape.EAST_WEST, Rail.Shape.ASCENDING_EAST, Rail.Shape.ASCENDING_WEST -> new BlockFace[]{BlockFace.EAST, BlockFace.WEST};
            default -> new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
        }) {
            Block adjacent = railBlock.getRelative(face);
            if (adjacent.getType() == Material.POWERED_RAIL || adjacent.getType() == Material.RAIL || adjacent.getType() == Material.ACTIVATOR_RAIL || adjacent.getType() == Material.DETECTOR_RAIL) continue;
            endDirection = face;
            break;
        }
        if (endDirection != null) {
            return railBlock.getRelative(endDirection);
        }
        return null;
    }

    private boolean isRailEnd(Block railBlock, BlockFace direction) {
        Block adjacentBlock = railBlock.getRelative(direction);
        return adjacentBlock.getType() != Material.POWERED_RAIL && adjacentBlock.getType() != Material.RAIL && adjacentBlock.getType() != Material.ACTIVATOR_RAIL && adjacentBlock.getType() != Material.DETECTOR_RAIL;
    }

    private boolean isInventoryEmpty(Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) == null) continue;
            return false;
        }
        return true;
    }

    private boolean isInventoryFull(Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) == null) {
                return false;
            }
            if (Objects.requireNonNull(inventory.getItem(i)).getAmount() >= Objects.requireNonNull(inventory.getItem(i)).getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private void pushMinecart(HopperMinecart hopperMinecart) {
        Block railBlock = hopperMinecart.getLocation().getBlock();
        if (railBlock.getType() != Material.POWERED_RAIL) {
            return;
        }
        Vector pushVector = this.determinePushDirection(railBlock, (Minecart)hopperMinecart);
        double pushStrength = this.plugin.getConfig().getDouble("minecart-loader.push-strength", 0.6);
        hopperMinecart.setVelocity(pushVector.multiply(pushStrength));
        if (this.plugin.getConfig().getBoolean("minecart-loader.debug", false)) {
            this.plugin.getLogger().info("Pushing minecart with vector: " + String.valueOf(pushVector));
        }
    }

    private Vector determinePushDirection(Block railBlock, Minecart minecart) {
        Rail rail = (Rail)railBlock.getBlockData();
        Rail.Shape shape = rail.getShape();
        BlockFace openFace = null;
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
            Block adjacent = railBlock.getRelative(face);
            if (adjacent.getType() != Material.POWERED_RAIL && adjacent.getType() != Material.RAIL && adjacent.getType() != Material.ACTIVATOR_RAIL && adjacent.getType() != Material.DETECTOR_RAIL) continue;
            openFace = face;
            break;
        }
        if (openFace != null) {
            switch (openFace) {
                case NORTH: {
                    return new Vector(0, 0, -1);
                }
                case SOUTH: {
                    return new Vector(0, 0, 1);
                }
                case EAST: {
                    return new Vector(1, 0, 0);
                }
                case WEST: {
                    return new Vector(-1, 0, 0);
                }
            }
        }
        switch (shape) {
            case NORTH_SOUTH: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                return new Vector(0, 0, 1);
            }
        }
        return new Vector(1, 0, 0);
    }

    private boolean isPathOpen(Block railBlock, BlockFace face) {
        Block adjacent = railBlock.getRelative(face);
        return adjacent.getType() == Material.POWERED_RAIL || adjacent.getType() == Material.RAIL || adjacent.getType() == Material.ACTIVATOR_RAIL || adjacent.getType() == Material.DETECTOR_RAIL;
    }
}

