/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.enhancedRails;

import com.elfahja.enhancedRails.MinecartLoader;
import com.elfahja.enhancedRails.RailListener;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EnhancedRails
extends JavaPlugin {
    public void onEnable() {
        this.saveDefaultConfig();
        this.migrateConfig();
        this.getLogger().info("EnhancedRails is now enabled! Config loaded from " + this.getDataFolder().getPath());
        this.getServer().getPluginManager().registerEvents((Listener)new RailListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MinecartLoader(this), (Plugin)this);
    }

    private void migrateConfig() {
        boolean configChanged = false;
        if (!this.getConfig().contains("minecart-loader")) {
            this.getLogger().info("Config migration: Adding minecart-loader section (v1.1 feature)");
            this.getConfig().set("minecart-loader.enabled", (Object)true);
            this.getConfig().set("minecart-loader.push-strength", (Object)1.0);
            this.getConfig().set("minecart-loader.special-block.enabled", (Object)true);
            this.getConfig().set("minecart-loader.special-block.material", (Object)"SMOOTH_STONE");
            configChanged = true;
        }
        if (!this.getConfig().contains("auto-slowdown")) {
            this.getLogger().info("Config migration: Adding auto-slowdown section (v1.2 feature)");
            this.getConfig().set("auto-slowdown.enabled", (Object)true);
            this.getConfig().set("auto-slowdown.look-ahead-blocks", (Object)3);
            this.getConfig().set("auto-slowdown.safe-speed", (Object)0.4);
            configChanged = true;
        }
        if (configChanged) {
            this.saveConfig();
            this.getLogger().info("Config migration complete. New settings have been added.");
        }
    }

    public void onDisable() {
        this.getLogger().info("EnhancedRails is shutting down. Goodbye, speedy rails!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("enhancedrails")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /enhancedrails [reload]");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("enhancedrails.use")) {
                    sender.sendMessage("You don't have permission to reload EnhancedRails!");
                    return true;
                }
                this.reloadConfig();
                this.migrateConfig();
                sender.sendMessage("EnhancedRails config reloaded!");
                this.getLogger().info("Config reloaded by " + sender.getName());
                return true;
            }
            sender.sendMessage("Unknown subcommand. Usage: /enhancedrails [reload]");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("enhancedrails") && args.length == 1) {
            return List.of("reload");
        }
        return null;
    }
}

