/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.enhancedRails;

import com.elfahja.enhancedRails.MinecartLoader;
import com.elfahja.enhancedRails.RailListener;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EnhancedRails
extends JavaPlugin {
    public void onEnable() {
        this.saveDefaultConfig();
        this.getLogger().info("EnhancedRails is now enabled! Config loaded from " + this.getDataFolder().getPath());
        this.getServer().getPluginManager().registerEvents((Listener)new RailListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MinecartLoader(this), (Plugin)this);
    }

    public void onDisable() {
        this.getLogger().info("EnhancedRails is shutting down. Goodbye, speedy rails!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("enhancedrails")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /enhancedrails [reload]");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("enhancedrails.use")) {
                    sender.sendMessage("You don't have permission to reload EnhancedRails!");
                    return true;
                }
                this.reloadConfig();
                sender.sendMessage("EnhancedRails config reloaded!");
                this.getLogger().info("Config reloaded by " + sender.getName());
                return true;
            }
            sender.sendMessage("Unknown subcommand. Usage: /enhancedrails [reload]");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("enhancedrails") && args.length == 1) {
            return List.of("reload");
        }
        return null;
    }
}

