/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade;

import com.elfahja.chesttrade.commands.AdminCommandExecutor;
import com.elfahja.chesttrade.data.TradeChestRegistry;
import com.elfahja.chesttrade.items.TradabilityBookItem;
import com.elfahja.chesttrade.items.TradeChestItem;
import com.elfahja.chesttrade.listeners.CopperGolemListener;
import com.elfahja.chesttrade.listeners.CraftingListener;
import com.elfahja.chesttrade.listeners.PlayerLoginListener;
import com.elfahja.chesttrade.listeners.TradeChestDisplayTask;
import com.elfahja.chesttrade.listeners.TradeChestListener;
import com.elfahja.chesttrade.listeners.TradeChestParticleTask;
import com.elfahja.chesttrade.listeners.TradingListener;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ChestTrade
extends JavaPlugin {
    private static ChestTrade instance;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        TradeChestRegistry.getInstance();
        this.registerRecipes();
        this.registerListeners();
        if (this.getConfig().getBoolean("display.particles-enabled", true)) {
            new TradeChestParticleTask((Plugin)this).start();
            this.getLogger().info("Trade Chest particles enabled");
        }
        if (this.getConfig().getBoolean("display.actionbar-enabled", true)) {
            new TradeChestDisplayTask((Plugin)this).start();
            this.getLogger().info("Trade Chest ActionBar display enabled");
        }
        String mode = this.getConfig().getString("mode", "simple");
        this.getLogger().info("Operating mode: " + mode.toUpperCase());
        this.getCommand("chesttrade").setExecutor((CommandExecutor)this);
        AdminCommandExecutor adminExecutor = new AdminCommandExecutor();
        this.getCommand("ctadmin").setExecutor((CommandExecutor)adminExecutor);
        this.getCommand("ctadmin").setTabCompleter((TabCompleter)adminExecutor);
        this.getLogger().info("ChestTrade enabled!");
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new TradeChestListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TradingListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftingListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerLoginListener(), (Plugin)this);
        if (CopperGolemListener.isSupported()) {
            this.getServer().getPluginManager().registerEvents((Listener)new CopperGolemListener((Plugin)this), (Plugin)this);
            this.getLogger().info("Copper Golem protection enabled (Paper 1.21.10+)");
        } else {
            this.getLogger().info("Copper Golem protection not available (requires Paper 1.21.10+)");
        }
        if (this.getConfig().getBoolean("abandonment.enabled", false)) {
            int days = this.getConfig().getInt("abandonment.days", 30);
            this.getLogger().info("Abandonment system enabled (" + days + " days)");
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendUsage(player);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("give") && args.length >= 2) {
            String itemType = args[1].toLowerCase();
            if (itemType.equals("chest") || itemType.equals("barrel") || itemType.equals("trapped")) {
                int tier = 5;
                if (args.length >= 3) {
                    try {
                        tier = Math.max(1, Math.min(5, Integer.parseInt(args[2])));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Material containerType = switch (itemType) {
                    case "barrel" -> Material.BARREL;
                    case "trapped" -> Material.TRAPPED_CHEST;
                    default -> Material.CHEST;
                };
                int minTier = TradeChestItem.getMinTierForContainer(containerType);
                if (tier < minTier) {
                    player.sendMessage("Error: " + itemType + " requires Tier " + this.toRoman(minTier) + "+");
                    return true;
                }
                String containerName = switch (itemType) {
                    case "barrel" -> "Trade Barrel";
                    case "trapped" -> "Trade Trapped Chest";
                    default -> "Trade Chest";
                };
                player.getInventory().addItem(new ItemStack[]{TradeChestItem.create(containerType, tier)});
                player.sendMessage("Gave you a Tier " + this.toRoman(tier) + " " + containerName + "!");
                return true;
            }
            if (itemType.equals("book")) {
                int tier = 1;
                if (args.length >= 3) {
                    try {
                        tier = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                player.getInventory().addItem(new ItemStack[]{TradabilityBookItem.create(tier)});
                player.sendMessage("Gave you a Tradability " + this.toRoman(tier) + " book!");
                return true;
            }
        }
        this.sendUsage(player);
        return true;
    }

    private void sendUsage(Player player) {
        player.sendMessage("ChestTrade Commands:");
        player.sendMessage("  /chesttrade give <chest|barrel|trapped|book> [tier]");
    }

    private String toRoman(int tier) {
        return switch (tier) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(tier);
        };
    }

    public void onDisable() {
        this.getLogger().info("ChestTrade disabled!");
    }

    private void registerRecipes() {
        String mode = this.getConfig().getString("mode", "simple");
        if ("simple".equalsIgnoreCase(mode)) {
            NamespacedKey key = new NamespacedKey((Plugin)this, "trade_chest_simple");
            ShapedRecipe recipe = new ShapedRecipe(key, TradeChestItem.create());
            recipe.shape(new String[]{"E", "C", " "});
            recipe.setIngredient('E', Material.EMERALD);
            recipe.setIngredient('C', Material.CHEST);
            this.getServer().addRecipe((Recipe)recipe);
            this.getLogger().info("Registered Simple Mode Trade Chest recipe");
        } else {
            this.registerStandardModeRecipes();
        }
    }

    private void registerStandardModeRecipes() {
        NamespacedKey bookKey = new NamespacedKey((Plugin)this, "tradability_book_1");
        ShapedRecipe bookRecipe = new ShapedRecipe(bookKey, TradabilityBookItem.create(1));
        bookRecipe.shape(new String[]{"E", "L", "B"});
        bookRecipe.setIngredient('E', Material.EMERALD);
        bookRecipe.setIngredient('L', Material.LAPIS_LAZULI);
        bookRecipe.setIngredient('B', Material.BOOK);
        this.getServer().addRecipe((Recipe)bookRecipe);
        this.getLogger().info("Registered Tradability Book I recipe (Tier II-V earned via trading XP)");
        NamespacedKey chestKey = new NamespacedKey((Plugin)this, "trade_chest_standard");
        ShapedRecipe chestRecipe = new ShapedRecipe(chestKey, TradeChestItem.create(Material.CHEST, 1));
        chestRecipe.shape(new String[]{"E", "T", "C"});
        chestRecipe.setIngredient('E', Material.EMERALD);
        chestRecipe.setIngredient('T', Material.ENCHANTED_BOOK);
        chestRecipe.setIngredient('C', Material.CHEST);
        this.getServer().addRecipe((Recipe)chestRecipe);
        this.getLogger().info("Registered Trade Chest recipe (Standard Mode)");
        NamespacedKey trappedKey = new NamespacedKey((Plugin)this, "trade_trapped_chest");
        ShapedRecipe trappedRecipe = new ShapedRecipe(trappedKey, TradeChestItem.create(Material.TRAPPED_CHEST, 2));
        trappedRecipe.shape(new String[]{"E", "T", "C"});
        trappedRecipe.setIngredient('E', Material.EMERALD);
        trappedRecipe.setIngredient('T', Material.ENCHANTED_BOOK);
        trappedRecipe.setIngredient('C', Material.TRAPPED_CHEST);
        this.getServer().addRecipe((Recipe)trappedRecipe);
        this.getLogger().info("Registered Trade Trapped Chest recipe");
        NamespacedKey barrelKey = new NamespacedKey((Plugin)this, "trade_barrel");
        ShapedRecipe barrelRecipe = new ShapedRecipe(barrelKey, TradeChestItem.create(Material.BARREL, 2));
        barrelRecipe.shape(new String[]{"E", "T", "C"});
        barrelRecipe.setIngredient('E', Material.EMERALD);
        barrelRecipe.setIngredient('T', Material.ENCHANTED_BOOK);
        barrelRecipe.setIngredient('C', Material.BARREL);
        this.getServer().addRecipe((Recipe)barrelRecipe);
        this.getLogger().info("Registered Trade Barrel recipe");
    }

    public static ChestTrade getInstance() {
        return instance;
    }
}

