/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.commands;

import com.elfahja.chesttrade.ChestTrade;
import com.elfahja.chesttrade.data.TradeChestRegistry;
import com.elfahja.chesttrade.items.TradabilityBookItem;
import com.elfahja.chesttrade.items.TradeChestItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.TileState;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdminCommandExecutor
implements CommandExecutor,
TabCompleter {
    private static final int PAGE_SIZE = 8;
    private final Map<String, PendingPurge> pendingPurges = new HashMap<String, PendingPurge>();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("chesttrade.admin")) {
            sender.sendMessage((Component)Component.text((String)"You don't have permission to use this command.", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        return switch (subCommand = args[0].toLowerCase()) {
            case "give" -> this.handleGive(sender, args);
            case "cleanup" -> this.handleCleanup(sender);
            case "list" -> this.handleList(sender, args);
            case "jail" -> this.handleJail(sender, args);
            case "unjail" -> this.handleUnjail(sender, args);
            case "purge" -> this.handlePurge(sender, args);
            case "transfer" -> this.handleTransfer(sender, args);
            case "stats" -> this.handleStats(sender);
            case "reload" -> this.handleReload(sender);
            case "inspect" -> this.handleInspect(sender);
            default -> {
                this.sendHelp(sender);
                yield true;
            }
        };
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage((Component)Component.text((String)"=== ChestTrade Admin Commands ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"/ctadmin give <book|chest|barrel|trapped> [tier]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Give Trade items", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin cleanup", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Remove orphaned chest entries", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin list [player] [page]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - List Trade Chests", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin jail <player>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Prevent player from creating chests", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin unjail <player>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Allow player to create chests again", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin purge <player>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Destroy all chests for a player (requires confirm)", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin transfer <from> <to>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Transfer chest ownership", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin stats", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show server statistics", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin reload", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Reload configuration", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/ctadmin inspect", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Inspect chest you're looking at", (TextColor)NamedTextColor.GRAY)));
    }

    private boolean handleGive(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"This command can only be used by players.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            sender.sendMessage((Component)Component.text((String)"Usage: /ctadmin give <book|chest|barrel|trapped> [tier 1-5]", (TextColor)NamedTextColor.RED));
            return true;
        }
        String itemType = args[1].toLowerCase();
        int tier = 5;
        if (args.length >= 3) {
            try {
                tier = Integer.parseInt(args[2]);
                tier = Math.max(1, Math.min(5, tier));
            }
            catch (NumberFormatException e) {
                sender.sendMessage((Component)Component.text((String)"Invalid tier. Use 1-5.", (TextColor)NamedTextColor.RED));
                return true;
            }
        }
        switch (itemType) {
            case "book": {
                player.getInventory().addItem(new ItemStack[]{TradabilityBookItem.create(tier)});
                sender.sendMessage((Component)Component.text((String)("Gave you a Tradability " + this.toRoman(tier) + " book."), (TextColor)NamedTextColor.GREEN));
                break;
            }
            case "chest": {
                player.getInventory().addItem(new ItemStack[]{TradeChestItem.create(Material.CHEST, tier)});
                sender.sendMessage((Component)Component.text((String)("Gave you a Tier " + this.toRoman(tier) + " Trade Chest."), (TextColor)NamedTextColor.GREEN));
                break;
            }
            case "barrel": {
                int minTier = TradeChestItem.getMinTierForContainer(Material.BARREL);
                if (tier < minTier) {
                    sender.sendMessage((Component)Component.text((String)("Trade Barrel requires Tier " + this.toRoman(minTier) + "+. Giving Tier " + this.toRoman(minTier) + "."), (TextColor)NamedTextColor.YELLOW));
                    tier = minTier;
                }
                player.getInventory().addItem(new ItemStack[]{TradeChestItem.create(Material.BARREL, tier)});
                sender.sendMessage((Component)Component.text((String)("Gave you a Tier " + this.toRoman(tier) + " Trade Barrel."), (TextColor)NamedTextColor.GREEN));
                break;
            }
            case "trapped": {
                int minTier = TradeChestItem.getMinTierForContainer(Material.TRAPPED_CHEST);
                if (tier < minTier) {
                    sender.sendMessage((Component)Component.text((String)("Trade Trapped Chest requires Tier " + this.toRoman(minTier) + "+. Giving Tier " + this.toRoman(minTier) + "."), (TextColor)NamedTextColor.YELLOW));
                    tier = minTier;
                }
                player.getInventory().addItem(new ItemStack[]{TradeChestItem.create(Material.TRAPPED_CHEST, tier)});
                sender.sendMessage((Component)Component.text((String)("Gave you a Tier " + this.toRoman(tier) + " Trade Trapped Chest."), (TextColor)NamedTextColor.GREEN));
                break;
            }
            default: {
                sender.sendMessage((Component)Component.text((String)"Unknown item type. Use: book, chest, barrel, trapped", (TextColor)NamedTextColor.RED));
            }
        }
        return true;
    }

    private String toRoman(int tier) {
        return switch (tier) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(tier);
        };
    }

    private boolean handleCleanup(CommandSender sender) {
        sender.sendMessage((Component)Component.text((String)"Scanning for orphaned chest entries...", (TextColor)NamedTextColor.YELLOW));
        int removed = TradeChestRegistry.getInstance().cleanup();
        if (removed == 0) {
            sender.sendMessage((Component)Component.text((String)"No orphaned entries found.", (TextColor)NamedTextColor.GREEN));
        } else {
            sender.sendMessage((Component)Component.text((String)("Removed " + removed + " orphaned entry(s)."), (TextColor)NamedTextColor.GREEN));
        }
        return true;
    }

    private boolean handleList(CommandSender sender, String[] args) {
        UUID filterPlayer = null;
        int page = 1;
        for (int i = 1; i < args.length; ++i) {
            try {
                page = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e2) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[i]);
                if (player.hasPlayedBefore() || player.isOnline()) {
                    filterPlayer = player.getUniqueId();
                    continue;
                }
                sender.sendMessage((Component)Component.text((String)("Player not found: " + args[i]), (TextColor)NamedTextColor.RED));
                return true;
            }
        }
        List<Map.Entry<Location, TradeChestRegistry.ChestData>> chests = TradeChestRegistry.getInstance().getAllChests();
        if (filterPlayer != null) {
            UUID finalFilter = filterPlayer;
            chests = chests.stream().filter(e -> ((TradeChestRegistry.ChestData)e.getValue()).owner.equals(finalFilter)).toList();
        }
        if (chests.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)"No Trade Chests found.", (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        int totalPages = (int)Math.ceil((double)chests.size() / 8.0);
        page = Math.max(1, Math.min(page, totalPages));
        int start = (page - 1) * 8;
        int end = Math.min(start + 8, chests.size());
        String header = filterPlayer != null ? "=== Trade Chests for " + chests.get((int)0).getValue().ownerName + " ===" : "=== All Trade Chests ===";
        sender.sendMessage((Component)Component.text((String)header, (TextColor)NamedTextColor.GOLD));
        sender.sendMessage((Component)Component.text((String)("Page " + page + "/" + totalPages + " (" + chests.size() + " total)"), (TextColor)NamedTextColor.GRAY));
        for (int i = start; i < end; ++i) {
            Map.Entry<Location, TradeChestRegistry.ChestData> entry = chests.get(i);
            Location loc = entry.getKey();
            TradeChestRegistry.ChestData data = entry.getValue();
            String coords = String.format("%s @ %d,%d,%d", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            Component line = ((TextComponent)((TextComponent)Component.text((String)(i + 1 + ". "), (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)data.ownerName, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)(" T" + data.tier + " "), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)coords, (TextColor)NamedTextColor.GRAY));
            if (sender instanceof Player) {
                line = line.clickEvent(ClickEvent.runCommand((String)("/tp " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ()))).hoverEvent((HoverEventSource)Component.text((String)"Click to teleport"));
            }
            sender.sendMessage(line);
        }
        if (totalPages > 1) {
            TextComponent nav = Component.empty();
            if (page > 1) {
                String prevCmd = filterPlayer != null ? "/ctadmin list " + chests.get((int)0).getValue().ownerName + " " + (page - 1) : "/ctadmin list " + (page - 1);
                nav = nav.append(Component.text((String)"[< Prev] ", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)prevCmd)));
            }
            if (page < totalPages) {
                String nextCmd = filterPlayer != null ? "/ctadmin list " + chests.get((int)0).getValue().ownerName + " " + (page + 1) : "/ctadmin list " + (page + 1);
                nav = nav.append(Component.text((String)"[Next >]", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)nextCmd)));
            }
            sender.sendMessage((Component)nav);
        }
        return true;
    }

    private boolean handleJail(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage((Component)Component.text((String)"Usage: /ctadmin jail <player>", (TextColor)NamedTextColor.RED));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage((Component)Component.text((String)("Player not found: " + args[1]), (TextColor)NamedTextColor.RED));
            return true;
        }
        if (TradeChestRegistry.getInstance().isJailed(target.getUniqueId())) {
            sender.sendMessage((Component)Component.text((String)(target.getName() + " is already jailed."), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        TradeChestRegistry.getInstance().jail(target.getUniqueId());
        sender.sendMessage((Component)Component.text((String)("Jailed " + target.getName() + ". All trade activities suspended."), (TextColor)NamedTextColor.GREEN));
        if (target.isOnline()) {
            target.getPlayer().sendMessage(Component.text((String)"[ChestTrade] ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"You have been restricted from all trade activities (creating chests, selling items).", (TextColor)NamedTextColor.RED)));
        }
        return true;
    }

    private boolean handleUnjail(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage((Component)Component.text((String)"Usage: /ctadmin unjail <player>", (TextColor)NamedTextColor.RED));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage((Component)Component.text((String)("Player not found: " + args[1]), (TextColor)NamedTextColor.RED));
            return true;
        }
        if (!TradeChestRegistry.getInstance().isJailed(target.getUniqueId())) {
            sender.sendMessage((Component)Component.text((String)(target.getName() + " is not jailed."), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        TradeChestRegistry.getInstance().unjail(target.getUniqueId());
        sender.sendMessage((Component)Component.text((String)("Unjailed " + target.getName() + ". Trade activities restored."), (TextColor)NamedTextColor.GREEN));
        if (target.isOnline()) {
            target.getPlayer().sendMessage(Component.text((String)"[ChestTrade] ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Your trade restrictions have been lifted.", (TextColor)NamedTextColor.GREEN)));
        }
        return true;
    }

    private boolean handlePurge(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage((Component)Component.text((String)"Usage: /ctadmin purge <player>", (TextColor)NamedTextColor.RED));
            return true;
        }
        String senderName = sender.getName();
        if (args[1].equalsIgnoreCase("confirm")) {
            PendingPurge pending = this.pendingPurges.remove(senderName);
            if (pending == null || System.currentTimeMillis() > pending.expiresAt()) {
                sender.sendMessage((Component)Component.text((String)"No pending purge to confirm (expired or none requested).", (TextColor)NamedTextColor.RED));
                return true;
            }
            return this.executePurge(sender, pending.playerName(), pending.playerUuid());
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage((Component)Component.text((String)("Player not found: " + args[1]), (TextColor)NamedTextColor.RED));
            return true;
        }
        List<Location> chests = TradeChestRegistry.getInstance().getPlayerChests(target.getUniqueId());
        if (chests.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)(target.getName() + " has no Trade Chests."), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        int count = chests.size();
        this.pendingPurges.put(senderName, new PendingPurge(target.getName(), target.getUniqueId(), System.currentTimeMillis() + 30000L));
        sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"WARNING: ", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append(Component.text((String)("This will permanently destroy " + count + " Trade Chest(s) belonging to "), (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, false))).append((Component)Component.text((String)target.getName(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"!", (TextColor)NamedTextColor.RED)));
        sender.sendMessage((Component)Component.text((String)"All chest contents will be dropped as items.", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(((TextComponent)Component.text((String)"Type ", (TextColor)NamedTextColor.GRAY).append(Component.text((String)"/ctadmin purge confirm", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.suggestCommand((String)"/ctadmin purge confirm")))).append((Component)Component.text((String)" within 30 seconds to proceed.", (TextColor)NamedTextColor.GRAY)));
        return true;
    }

    private boolean executePurge(CommandSender sender, String playerName, UUID playerUuid) {
        List<Location> chests = TradeChestRegistry.getInstance().getPlayerChests(playerUuid);
        if (chests.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)(playerName + " no longer has any Trade Chests."), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        int count = chests.size();
        for (Location loc : chests) {
            Block block = loc.getBlock();
            ItemStack[] itemStackArray = block.getState();
            if (itemStackArray instanceof Container) {
                Container container = (Container)itemStackArray;
                for (ItemStack item : container.getInventory().getContents()) {
                    if (item == null || item.getType().isAir()) continue;
                    block.getWorld().dropItemNaturally(loc, item);
                }
                container.getInventory().clear();
            }
            TradeChestRegistry.getInstance().unregister(loc);
            block.breakNaturally();
        }
        sender.sendMessage((Component)Component.text((String)("Purged " + count + " Trade Chest(s) belonging to " + playerName + "."), (TextColor)NamedTextColor.GREEN));
        return true;
    }

    private boolean handleTransfer(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage((Component)Component.text((String)"Usage: /ctadmin transfer <from> <to>", (TextColor)NamedTextColor.RED));
            return true;
        }
        OfflinePlayer fromPlayer = Bukkit.getOfflinePlayer((String)args[1]);
        OfflinePlayer toPlayer = Bukkit.getOfflinePlayer((String)args[2]);
        if (!fromPlayer.hasPlayedBefore() && !fromPlayer.isOnline()) {
            sender.sendMessage((Component)Component.text((String)("Player not found: " + args[1]), (TextColor)NamedTextColor.RED));
            return true;
        }
        if (!toPlayer.hasPlayedBefore() && !toPlayer.isOnline()) {
            sender.sendMessage((Component)Component.text((String)("Player not found: " + args[2]), (TextColor)NamedTextColor.RED));
            return true;
        }
        List<Location> chests = TradeChestRegistry.getInstance().getPlayerChests(fromPlayer.getUniqueId());
        if (chests.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)(fromPlayer.getName() + " has no Trade Chests."), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        int count = chests.size();
        for (Location loc : chests) {
            TradeChestRegistry.ChestData oldData;
            Block block = loc.getBlock();
            BlockState blockState = block.getState();
            if (blockState instanceof TileState) {
                TileState tileState = (TileState)blockState;
                PersistentDataContainer pdc = tileState.getPersistentDataContainer();
                pdc.set(new NamespacedKey((Plugin)ChestTrade.getInstance(), "owner"), PersistentDataType.STRING, (Object)toPlayer.getUniqueId().toString());
                tileState.update();
            }
            if ((oldData = TradeChestRegistry.getInstance().getChestData(loc)) == null) continue;
            TradeChestRegistry.getInstance().unregister(loc);
            TradeChestRegistry.getInstance().register(loc, toPlayer.getUniqueId(), toPlayer.getName(), oldData.tier);
        }
        sender.sendMessage((Component)Component.text((String)("Transferred " + count + " Trade Chest(s) from " + fromPlayer.getName() + " to " + toPlayer.getName() + "."), (TextColor)NamedTextColor.GREEN));
        return true;
    }

    private boolean handleStats(CommandSender sender) {
        TradeChestRegistry registry = TradeChestRegistry.getInstance();
        List<Map.Entry<Location, TradeChestRegistry.ChestData>> allChests = registry.getAllChests();
        sender.sendMessage((Component)Component.text((String)"=== ChestTrade Statistics ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"Total Trade Chests: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)String.valueOf(allChests.size()), (TextColor)NamedTextColor.WHITE)));
        HashMap<Integer, Integer> tierCounts = new HashMap<Integer, Integer>();
        HashMap<UUID, Integer> playerCounts = new HashMap<UUID, Integer>();
        int abandonedCount = 0;
        for (Map.Entry<Location, TradeChestRegistry.ChestData> entry : allChests) {
            TradeChestRegistry.ChestData data = entry.getValue();
            tierCounts.merge(data.tier, 1, Integer::sum);
            playerCounts.merge(data.owner, 1, Integer::sum);
            if (!registry.isAbandoned(entry.getKey())) continue;
            ++abandonedCount;
        }
        TextComponent tierLine = Component.text((String)"By Tier: ", (TextColor)NamedTextColor.YELLOW);
        for (int tier = 1; tier <= 5; ++tier) {
            int count = tierCounts.getOrDefault(tier, 0);
            if (count <= 0) continue;
            tierLine = tierLine.append((Component)Component.text((String)("T" + tier + "=" + count + " "), (TextColor)NamedTextColor.AQUA));
        }
        sender.sendMessage((Component)tierLine);
        sender.sendMessage(Component.text((String)"Unique Owners: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)String.valueOf(playerCounts.size()), (TextColor)NamedTextColor.WHITE)));
        if (ChestTrade.getInstance().getConfig().getBoolean("abandonment.enabled", false)) {
            sender.sendMessage(Component.text((String)"Abandoned: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)String.valueOf(abandonedCount), (TextColor)NamedTextColor.RED)));
        }
        int jailedCount = registry.getJailedCount();
        sender.sendMessage(Component.text((String)"Jailed Players: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)String.valueOf(jailedCount), (TextColor)NamedTextColor.WHITE)));
        if (!playerCounts.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)"Top Owners:", (TextColor)NamedTextColor.YELLOW));
            playerCounts.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(5L).forEach(e -> {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)((UUID)e.getKey()));
                sender.sendMessage((Component)Component.text((String)("  " + player.getName() + ": " + String.valueOf(e.getValue())), (TextColor)NamedTextColor.GRAY));
            });
        }
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        ChestTrade.getInstance().reloadConfig();
        TradeChestRegistry.getInstance().load();
        sender.sendMessage((Component)Component.text((String)"ChestTrade configuration reloaded.", (TextColor)NamedTextColor.GREEN));
        sender.sendMessage((Component)Component.text((String)"Note: Recipe changes require a server restart.", (TextColor)NamedTextColor.YELLOW));
        return true;
    }

    private boolean handleInspect(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"This command can only be used by players.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        Block target = player.getTargetBlockExact(5);
        if (target == null) {
            sender.sendMessage((Component)Component.text((String)"Look at a block to inspect it.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Material type = target.getType();
        if (type != Material.CHEST && type != Material.TRAPPED_CHEST && type != Material.BARREL) {
            sender.sendMessage((Component)Component.text((String)"That's not a container.", (TextColor)NamedTextColor.RED));
            return true;
        }
        TradeChestRegistry.ChestData data = TradeChestRegistry.getInstance().getChestData(target.getLocation());
        if (data == null) {
            sender.sendMessage((Component)Component.text((String)"That's not a Trade Chest.", (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        int xp = 0;
        BlockState blockState = target.getState();
        if (blockState instanceof TileState) {
            TileState tileState = (TileState)blockState;
            PersistentDataContainer pdc = tileState.getPersistentDataContainer();
            xp = (Integer)pdc.getOrDefault(new NamespacedKey((Plugin)ChestTrade.getInstance(), "xp"), PersistentDataType.INTEGER, (Object)0);
        }
        sender.sendMessage((Component)Component.text((String)"=== Trade Chest Info ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"Owner: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)data.ownerName, (TextColor)NamedTextColor.WHITE)));
        sender.sendMessage(Component.text((String)"Tier: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)String.valueOf(data.tier), (TextColor)NamedTextColor.AQUA)));
        sender.sendMessage(Component.text((String)"XP: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)String.valueOf(xp), (TextColor)NamedTextColor.GREEN)));
        sender.sendMessage(Component.text((String)"Created: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)this.formatAge(data.created), (TextColor)NamedTextColor.GRAY)));
        if (ChestTrade.getInstance().getConfig().getBoolean("abandonment.enabled", false)) {
            boolean abandoned = TradeChestRegistry.getInstance().isAbandoned(target.getLocation());
            if (abandoned) {
                sender.sendMessage(Component.text((String)"Status: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)"ABANDONED", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
            } else {
                int daysUntil = TradeChestRegistry.getInstance().getDaysUntilAbandonment(target.getLocation());
                if (daysUntil > 0) {
                    sender.sendMessage(Component.text((String)"Abandonment in: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)(daysUntil + " days"), (TextColor)NamedTextColor.GRAY)));
                }
            }
        }
        sender.sendMessage(Component.text((String)"Location: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)String.format("%s @ %d,%d,%d", target.getWorld().getName(), target.getX(), target.getY(), target.getZ()), (TextColor)NamedTextColor.GRAY)));
        return true;
    }

    private String formatAge(long created) {
        long age = System.currentTimeMillis() - created;
        long days = age / 86400000L;
        if (days == 0L) {
            return "Today";
        }
        if (days == 1L) {
            return "1 day ago";
        }
        return days + " days ago";
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("chesttrade.admin")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return this.filterStartsWith(args[0], "give", "cleanup", "list", "jail", "unjail", "purge", "transfer", "stats", "reload", "inspect");
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("give")) {
            if (args.length == 2) {
                return this.filterStartsWith(args[1], "book", "chest", "barrel", "trapped");
            }
            if (args.length == 3) {
                return this.filterStartsWith(args[2], "1", "2", "3", "4", "5");
            }
        }
        if ((subCommand.equals("jail") || subCommand.equals("unjail") || subCommand.equals("list")) && args.length == 2) {
            return this.getOnlinePlayerNames(args[1]);
        }
        if (subCommand.equals("purge") && args.length == 2) {
            ArrayList<String> options = new ArrayList<String>(this.getOnlinePlayerNames(args[1]));
            if ("confirm".startsWith(args[1].toLowerCase())) {
                options.add("confirm");
            }
            return options;
        }
        if (subCommand.equals("transfer") && (args.length == 2 || args.length == 3)) {
            return this.getOnlinePlayerNames(args[args.length - 1]);
        }
        return Collections.emptyList();
    }

    private List<String> filterStartsWith(String prefix, String ... options) {
        return Arrays.stream(options).filter(s -> s.toLowerCase().startsWith(prefix.toLowerCase())).toList();
    }

    private List<String> getOnlinePlayerNames(String prefix) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(prefix.toLowerCase())).toList();
    }

    private record PendingPurge(String playerName, UUID playerUuid, long expiresAt) {
    }
}

