/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.listeners;

import com.elfahja.chesttrade.listeners.TradeChestListener;
import io.papermc.paper.event.entity.ItemTransportingEntityValidateTargetEvent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CopperGolemListener
implements Listener {
    private final Plugin plugin;

    public CopperGolemListener(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemTransportValidate(ItemTransportingEntityValidateTargetEvent event) {
        if (this.plugin.getConfig().getBoolean("entities.allow-copper-golems", false)) {
            return;
        }
        Block block = event.getBlock();
        if ((block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST) && TradeChestListener.isTradeChest(block)) {
            event.setAllowed(false);
        }
    }

    public static boolean isSupported() {
        try {
            Class.forName("io.papermc.paper.event.entity.ItemTransportingEntityValidateTargetEvent");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

