/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.listeners;

import com.elfahja.chesttrade.ChestTrade;
import com.elfahja.chesttrade.items.TradabilityBookItem;
import com.elfahja.chesttrade.items.TradeChestItem;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class CraftingListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        AnvilInventory inv = event.getInventory();
        ItemStack firstItem = inv.getFirstItem();
        ItemStack secondItem = inv.getSecondItem();
        if (TradabilityBookItem.isTradabilityBook(firstItem) || TradabilityBookItem.isTradabilityBook(secondItem)) {
            event.setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        ItemStack result = event.getInventory().getResult();
        if (result == null || result.getType().isAir()) {
            return;
        }
        if (TradeChestItem.isTradeChest(result)) {
            this.handleTradeChestCraft(event);
        }
    }

    private void handleTradeChestCraft(PrepareItemCraftEvent event) {
        int minTier;
        CraftingInventory inv = event.getInventory();
        String mode = ChestTrade.getInstance().getConfig().getString("mode", "simple");
        if ("simple".equalsIgnoreCase(mode)) {
            return;
        }
        ItemStack[] matrix = inv.getMatrix();
        int bookTier = 0;
        Material containerType = null;
        for (ItemStack item : matrix) {
            if (item == null || item.getType().isAir()) continue;
            if (TradabilityBookItem.isTradabilityBook(item)) {
                bookTier = TradabilityBookItem.getTier(item);
            }
            if (!TradeChestItem.isValidContainer(item.getType())) continue;
            containerType = item.getType();
        }
        if (bookTier == 0) {
            inv.setResult(null);
            return;
        }
        if (containerType != null && bookTier < (minTier = TradeChestItem.getMinTierForContainer(containerType))) {
            inv.setResult(null);
            return;
        }
        if (containerType != null) {
            inv.setResult(TradeChestItem.create(containerType, bookTier));
        }
    }
}

