/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.listeners;

import com.elfahja.chesttrade.ChestTrade;
import com.elfahja.chesttrade.DevMode;
import com.elfahja.chesttrade.data.TradeChestRegistry;
import com.elfahja.chesttrade.items.TradeChestItem;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class TradeChestListener
implements Listener {
    public static final NamespacedKey KEY_OWNER = new NamespacedKey("chesttrade", "owner");
    public static final NamespacedKey KEY_OWNER_NAME = new NamespacedKey("chesttrade", "owner_name");
    public static final NamespacedKey KEY_TIER = new NamespacedKey("chesttrade", "tier");
    public static final NamespacedKey KEY_TRADES = new NamespacedKey("chesttrade", "trades");
    public static final NamespacedKey KEY_XP = new NamespacedKey("chesttrade", "xp");
    public static final NamespacedKey KEY_TRADES_NOTIFIED = new NamespacedKey("chesttrade", "trades_notified");
    public static final NamespacedKey KEY_XP_NOTIFIED = new NamespacedKey("chesttrade", "xp_notified");
    private static final BlockFace[] HORIZONTAL_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private static final Set<Material> VALID_CONTAINERS = Set.of(Material.CHEST, Material.TRAPPED_CHEST, Material.BARREL);
    private static final Set<Material> DOUBLE_CHEST_CONTAINERS = Set.of(Material.CHEST, Material.TRAPPED_CHEST);

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        String placementError;
        int minTier;
        ItemStack item = event.getItemInHand();
        Block block = event.getBlockPlaced();
        Material blockType = block.getType();
        if (DOUBLE_CHEST_CONTAINERS.contains(blockType) && !TradeChestItem.isTradeChest(item)) {
            for (BlockFace face : HORIZONTAL_FACES) {
                Block adjacent = block.getRelative(face);
                if (!TradeChestListener.isTradeChest(adjacent) || adjacent.getType() != blockType) continue;
                event.setCancelled(true);
                event.getPlayer().sendActionBar(Component.text((String)("Cannot place " + this.formatMaterial(blockType) + " next to a Trade " + this.formatMaterial(blockType))).color((TextColor)NamedTextColor.RED));
                return;
            }
            return;
        }
        if (!TradeChestItem.isTradeChest(item)) {
            return;
        }
        if (!VALID_CONTAINERS.contains(blockType)) {
            return;
        }
        Player player = event.getPlayer();
        UUID ownerUuid = DevMode.getEffectiveUUID(player);
        String ownerName = DevMode.getEffectiveName(player);
        int placingTier = TradeChestItem.getTier(item);
        if (placingTier < (minTier = TradeChestItem.getMinTierForContainer(blockType))) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)(this.formatMaterial(blockType) + " requires Tier " + this.toRoman(minTier) + "+")).color((TextColor)NamedTextColor.RED));
            return;
        }
        if (TradeChestRegistry.getInstance().isJailed(ownerUuid)) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)"You are restricted from creating Trade Chests").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (DOUBLE_CHEST_CONTAINERS.contains(blockType) && (placementError = this.checkAdjacentChests(block, ownerUuid, placingTier)) != null) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)placementError).color((TextColor)NamedTextColor.RED));
            return;
        }
        String densityError = this.checkDensityLimit(block, ownerUuid, placingTier);
        if (densityError != null) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)densityError).color((TextColor)NamedTextColor.RED));
            return;
        }
        String globalLimitError = this.checkGlobalLimit(ownerUuid);
        if (globalLimitError != null) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)globalLimitError).color((TextColor)NamedTextColor.RED));
            return;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof TileState) {
            TileState tileState = (TileState)blockState;
            PersistentDataContainer pdc = tileState.getPersistentDataContainer();
            pdc.set(KEY_OWNER, PersistentDataType.STRING, (Object)ownerUuid.toString());
            pdc.set(KEY_OWNER_NAME, PersistentDataType.STRING, (Object)ownerName);
            int tier = TradeChestItem.getTier(item);
            pdc.set(KEY_TIER, PersistentDataType.INTEGER, (Object)tier);
            pdc.set(KEY_TRADES, PersistentDataType.INTEGER, (Object)0);
            String containerName = this.formatMaterial(blockType);
            if (tileState instanceof Nameable) {
                Nameable nameable = (Nameable)tileState;
                nameable.customName((Component)Component.text((String)("Trade " + containerName)));
            }
            tileState.update();
            TradeChestRegistry.getInstance().register(block.getLocation(), ownerUuid, ownerName, tier);
            player.sendActionBar(Component.text((String)("Trade " + containerName + " placed! Set your price in slot 1.")).color((TextColor)NamedTextColor.GREEN));
            if (DevMode.isEnabled()) {
                player.sendMessage(Component.text((String)("[Dev] Placed as: " + ownerName)).color((TextColor)NamedTextColor.YELLOW));
            }
        }
    }

    private String formatMaterial(Material material) {
        String name = material.name().toLowerCase().replace('_', ' ');
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                result.append(c);
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        BlockState blockState;
        Block block = event.getBlock();
        Material blockType = block.getType();
        if (!VALID_CONTAINERS.contains(blockType)) {
            return;
        }
        BlockState blockState2 = block.getState();
        if (!(blockState2 instanceof TileState)) {
            return;
        }
        TileState tileState = (TileState)blockState2;
        PersistentDataContainer pdc = tileState.getPersistentDataContainer();
        String ownerString = (String)pdc.get(KEY_OWNER, PersistentDataType.STRING);
        if (ownerString == null) {
            return;
        }
        Player player = event.getPlayer();
        UUID ownerUuid = UUID.fromString(ownerString);
        UUID playerUuid = DevMode.getEffectiveUUID(player);
        String containerName = this.formatMaterial(blockType);
        boolean isAbandoned = TradeChestRegistry.getInstance().isAbandoned(block.getLocation());
        if (!ownerUuid.equals(playerUuid) && !isAbandoned) {
            String ownerName = (String)pdc.get(KEY_OWNER_NAME, PersistentDataType.STRING);
            player.sendActionBar(Component.text((String)("This Trade " + containerName + " belongs to " + ownerName)).color((TextColor)NamedTextColor.RED));
            event.setCancelled(true);
            if (DevMode.isEnabled()) {
                player.sendMessage(Component.text((String)("[Dev] Your identity: " + DevMode.getEffectiveName(player) + ", Owner: " + ownerName)).color((TextColor)NamedTextColor.YELLOW));
            }
            return;
        }
        if (isAbandoned && !ownerUuid.equals(playerUuid)) {
            String ownerName = (String)pdc.get(KEY_OWNER_NAME, PersistentDataType.STRING);
            player.sendActionBar(Component.text((String)("Breaking abandoned Trade " + containerName + " (was " + ownerName + "'s)")).color((TextColor)NamedTextColor.YELLOW));
        }
        event.setDropItems(false);
        Integer tier = (Integer)pdc.get(KEY_TIER, PersistentDataType.INTEGER);
        Integer trades = (Integer)pdc.get(KEY_TRADES, PersistentDataType.INTEGER);
        ItemStack tradeContainer = TradeChestItem.create(blockType, tier != null ? tier : 5);
        if (trades != null && trades > 0) {
            ItemMeta meta = tradeContainer.getItemMeta();
            meta.getPersistentDataContainer().set(TradeChestItem.KEY_TRADES, PersistentDataType.INTEGER, (Object)trades);
            tradeContainer.setItemMeta(meta);
        }
        if ((blockState = block.getState()) instanceof Chest) {
            Chest chest = (Chest)blockState;
            for (ItemStack content : chest.getInventory().getContents()) {
                if (content == null || content.getType().isAir()) continue;
                block.getWorld().dropItemNaturally(block.getLocation(), content);
            }
            chest.getInventory().clear();
        } else {
            blockState = block.getState();
            if (blockState instanceof Barrel) {
                Barrel barrel = (Barrel)blockState;
                for (ItemStack content : barrel.getInventory().getContents()) {
                    if (content == null || content.getType().isAir()) continue;
                    block.getWorld().dropItemNaturally(block.getLocation(), content);
                }
                barrel.getInventory().clear();
            }
        }
        block.getWorld().dropItemNaturally(block.getLocation(), tradeContainer);
        TradeChestRegistry.getInstance().unregister(block.getLocation());
        player.sendActionBar(Component.text((String)("Trade " + containerName + " retrieved!")).color((TextColor)NamedTextColor.GREEN));
    }

    private String checkAdjacentChests(Block block, UUID placingOwner, int placingTier) {
        Material placingType = block.getType();
        String containerName = this.formatMaterial(placingType);
        for (BlockFace face : HORIZONTAL_FACES) {
            Block adjacent = block.getRelative(face);
            if (adjacent.getType() != placingType) continue;
            if (!TradeChestListener.isTradeChest(adjacent)) {
                return "Cannot place Trade " + containerName + " next to a regular " + containerName.toLowerCase();
            }
            UUID adjacentOwner = TradeChestListener.getOwner(adjacent);
            if (!placingOwner.equals(adjacentOwner)) {
                return "Cannot place next to another player's Trade " + containerName;
            }
            int adjacentTier = TradeChestListener.getTier(adjacent);
            if (placingTier < 3 || adjacentTier < 3) {
                return "Double Trade " + containerName + "s require Tier III or higher";
            }
            if (placingTier == adjacentTier) continue;
            return "Double Trade " + containerName + "s must be the same tier";
        }
        return null;
    }

    private String checkDensityLimit(Block block, UUID ownerUuid, int tier) {
        FileConfiguration config = ChestTrade.getInstance().getConfig();
        String mode = config.getString("mode", "simple");
        if ("simple".equalsIgnoreCase(mode)) {
            return null;
        }
        if (tier >= 5) {
            return null;
        }
        int radius = config.getInt("density.radius", 100);
        int limit = config.getInt("density.tier-" + tier, 0);
        if (limit <= 0) {
            return null;
        }
        int count = this.countOwnedTradeChestsInRadius(block.getLocation(), ownerUuid, tier, radius);
        if (count >= limit) {
            return "Tier " + this.toRoman(tier) + " limit: " + count + "/" + limit + " in " + radius + " blocks";
        }
        return null;
    }

    private String checkGlobalLimit(UUID ownerUuid) {
        int limit = ChestTrade.getInstance().getConfig().getInt("limits.max-per-player", 0);
        if (limit <= 0) {
            return null;
        }
        int count = TradeChestRegistry.getInstance().countPlayerChests(ownerUuid);
        if (count >= limit) {
            return "Global limit reached: " + count + "/" + limit + " Trade Chests";
        }
        return null;
    }

    private int countOwnedTradeChestsInRadius(Location center, UUID ownerUuid, int tier, int radius) {
        int count = 0;
        int radiusSq = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block;
                    if (x * x + y * y + z * z > radiusSq || !TradeChestListener.isTradeChest(block = center.getBlock().getRelative(x, y, z))) continue;
                    UUID blockOwner = TradeChestListener.getOwner(block);
                    int blockTier = TradeChestListener.getTier(block);
                    if (!ownerUuid.equals(blockOwner) || blockTier != tier) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private String toRoman(int tier) {
        return switch (tier) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(tier);
        };
    }

    public static boolean isTradeChest(Block block) {
        if (!VALID_CONTAINERS.contains(block.getType())) {
            return false;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof TileState)) {
            return false;
        }
        TileState tileState = (TileState)blockState;
        PersistentDataContainer pdc = tileState.getPersistentDataContainer();
        return pdc.has(KEY_OWNER, PersistentDataType.STRING);
    }

    public static UUID getOwner(Block block) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof TileState)) {
            return null;
        }
        TileState tileState = (TileState)blockState;
        PersistentDataContainer pdc = tileState.getPersistentDataContainer();
        String ownerString = (String)pdc.get(KEY_OWNER, PersistentDataType.STRING);
        return ownerString != null ? UUID.fromString(ownerString) : null;
    }

    public static int getTier(Block block) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof TileState)) {
            return 0;
        }
        TileState tileState = (TileState)blockState;
        PersistentDataContainer pdc = tileState.getPersistentDataContainer();
        Integer tier = (Integer)pdc.get(KEY_TIER, PersistentDataType.INTEGER);
        return tier != null ? tier : 0;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSignPlace(BlockPlaceEvent event) {
        UUID playerUuid;
        Block placed = event.getBlockPlaced();
        Material type = placed.getType();
        if (!type.name().contains("WALL_SIGN") && !type.name().contains("WALL_HANGING_SIGN")) {
            return;
        }
        Block attachedTo = event.getBlockAgainst();
        if (!TradeChestListener.isTradeChest(attachedTo)) {
            return;
        }
        Player player = event.getPlayer();
        UUID ownerUuid = TradeChestListener.getOwner(attachedTo);
        if (!ownerUuid.equals(playerUuid = DevMode.getEffectiveUUID(player))) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)"Only the owner can place signs on this Trade Chest").color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSignBreak(BlockBreakEvent event) {
        UUID playerUuid;
        Block block = event.getBlock();
        Material type = block.getType();
        if (!type.name().contains("WALL_SIGN") && !type.name().contains("WALL_HANGING_SIGN")) {
            return;
        }
        Block attachedTo = this.getAttachedBlock(block);
        if (attachedTo == null || !TradeChestListener.isTradeChest(attachedTo)) {
            return;
        }
        Player player = event.getPlayer();
        UUID ownerUuid = TradeChestListener.getOwner(attachedTo);
        if (!ownerUuid.equals(playerUuid = DevMode.getEffectiveUUID(player))) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)"Only the owner can remove signs from this Trade Chest").color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemFramePlace(HangingPlaceEvent event) {
        Hanging entity = event.getEntity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        BlockFace attachedFace = itemFrame.getAttachedFace();
        Block frameBlock = event.getBlock();
        Block attachedTo = frameBlock.getRelative(attachedFace);
        if (!TradeChestListener.isTradeChest(attachedTo)) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            event.setCancelled(true);
            return;
        }
        UUID ownerUuid = TradeChestListener.getOwner(attachedTo);
        if (ownerUuid == null) {
            return;
        }
        UUID playerUuid = DevMode.getEffectiveUUID(player);
        if (!ownerUuid.equals(playerUuid)) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)"Only the owner can place item frames on this Trade Chest").color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemFrameBreak(HangingBreakByEntityEvent event) {
        Hanging hanging = event.getEntity();
        if (!(hanging instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)hanging;
        Block attachedTo = itemFrame.getLocation().getBlock().getRelative(itemFrame.getAttachedFace());
        if (!TradeChestListener.isTradeChest(attachedTo)) {
            return;
        }
        Entity remover = event.getRemover();
        if (!(remover instanceof Player)) {
            event.setCancelled(true);
            return;
        }
        Player player = (Player)remover;
        UUID ownerUuid = TradeChestListener.getOwner(attachedTo);
        UUID playerUuid = DevMode.getEffectiveUUID(player);
        if (!ownerUuid.equals(playerUuid)) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)"Only the owner can remove item frames from this Trade Chest").color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemFrameInteract(PlayerInteractEntityEvent event) {
        UUID playerUuid;
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        Block attachedTo = itemFrame.getLocation().getBlock().getRelative(itemFrame.getAttachedFace());
        if (!TradeChestListener.isTradeChest(attachedTo)) {
            return;
        }
        Player player = event.getPlayer();
        UUID ownerUuid = TradeChestListener.getOwner(attachedTo);
        if (!ownerUuid.equals(playerUuid = DevMode.getEffectiveUUID(player))) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)"Only the owner can modify item frames on this Trade Chest").color((TextColor)NamedTextColor.RED));
        }
    }

    private Block getAttachedBlock(Block signBlock) {
        BlockData blockData = signBlock.getBlockData();
        if (blockData instanceof Directional) {
            Directional directional = (Directional)blockData;
            BlockFace facing = directional.getFacing();
            return signBlock.getRelative(facing.getOppositeFace());
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material type = block.getType();
        if (!type.name().contains("SIGN")) {
            return;
        }
        Block attachedTo = this.getAttachedBlock(block);
        if (attachedTo == null || !TradeChestListener.isTradeChest(attachedTo)) {
            return;
        }
        Player player = event.getPlayer();
        UUID ownerUuid = TradeChestListener.getOwner(attachedTo);
        UUID playerUuid = DevMode.getEffectiveUUID(player);
        if (ownerUuid != null && !ownerUuid.equals(playerUuid)) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)"Only the owner can edit signs on this Trade Chest").color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemFramePunch(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        Block attachedTo = itemFrame.getLocation().getBlock().getRelative(itemFrame.getAttachedFace());
        if (!TradeChestListener.isTradeChest(attachedTo)) {
            return;
        }
        Entity damager = event.getDamager();
        if (!(damager instanceof Player)) {
            event.setCancelled(true);
            return;
        }
        Player player = (Player)damager;
        UUID ownerUuid = TradeChestListener.getOwner(attachedTo);
        UUID playerUuid = DevMode.getEffectiveUUID(player);
        if (ownerUuid != null && !ownerUuid.equals(playerUuid)) {
            event.setCancelled(true);
            player.sendActionBar(Component.text((String)"Only the owner can modify item frames on this Trade Chest").color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        event.blockList().removeIf(TradeChestListener::isTradeChest);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        event.blockList().removeIf(TradeChestListener::isTradeChest);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        InventoryHolder sourceHolder = event.getSource().getHolder();
        if (this.isTradeChestHolder(sourceHolder)) {
            event.setCancelled(true);
            return;
        }
        InventoryHolder destHolder = event.getDestination().getHolder();
        if (this.isTradeChestHolder(destHolder)) {
            event.setCancelled(true);
        }
    }

    private boolean isTradeChestHolder(InventoryHolder holder) {
        DoubleChest doubleChest;
        InventoryHolder leftSide;
        if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            return TradeChestListener.isTradeChest(chest.getBlock());
        }
        if (holder instanceof DoubleChest && (leftSide = (doubleChest = (DoubleChest)holder).getLeftSide()) instanceof Chest) {
            Chest leftChest = (Chest)leftSide;
            return TradeChestListener.isTradeChest(leftChest.getBlock());
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!TradeChestListener.isTradeChest(block)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (!TradeChestListener.isTradeChest(block)) continue;
            event.setCancelled(true);
            return;
        }
    }
}

