/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.listeners;

import com.elfahja.chesttrade.listeners.TradeChestListener;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TradeChestParticleTask
extends BukkitRunnable {
    private static final int SEARCH_RADIUS = 16;
    private static final int PARTICLE_COUNT = 3;
    private static final Particle PARTICLE_TYPE = Particle.HAPPY_VILLAGER;
    private static final Set<Material> VALID_CONTAINERS = Set.of(Material.CHEST, Material.TRAPPED_CHEST, Material.BARREL);
    private final Plugin plugin;

    public TradeChestParticleTask(Plugin plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.runTaskTimer(this.plugin, 20L, 20L);
    }

    public void run() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.spawnParticlesNearPlayer(player);
        }
    }

    private void spawnParticlesNearPlayer(Player player) {
        Location playerLoc = player.getLocation();
        int px = playerLoc.getBlockX();
        int py = playerLoc.getBlockY();
        int pz = playerLoc.getBlockZ();
        for (int x = px - 16; x <= px + 16; ++x) {
            for (int y = py - 16; y <= py + 16; ++y) {
                for (int z = pz - 16; z <= pz + 16; ++z) {
                    Block block = player.getWorld().getBlockAt(x, y, z);
                    if (!VALID_CONTAINERS.contains(block.getType()) || !TradeChestListener.isTradeChest(block)) continue;
                    Location particleLoc = block.getLocation().add(0.5, 1.2, 0.5);
                    player.spawnParticle(PARTICLE_TYPE, particleLoc, 3, 0.3, 0.2, 0.3, 0.01);
                }
            }
        }
    }
}

