/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.listeners;

import com.elfahja.chesttrade.ChestTrade;
import com.elfahja.chesttrade.DevMode;
import com.elfahja.chesttrade.data.TradeChestRegistry;
import com.elfahja.chesttrade.items.TradabilityBookItem;
import com.elfahja.chesttrade.listeners.TradeChestListener;
import com.elfahja.chesttrade.util.ItemValidator;
import com.elfahja.chesttrade.util.ItemValueTier;
import com.elfahja.chesttrade.util.ToastNotification;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.TileState;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TradingListener
implements Listener {
    private static final int PRICE_SLOT = 0;
    private static final int REWARD_SLOT_SINGLE = 26;
    private static final int REWARD_SLOT_DOUBLE = 53;
    private final Set<UUID> buyersViewing = new HashSet<UUID>();

    private int getRewardSlot(Inventory inv) {
        return inv.getSize() == 54 ? 53 : 26;
    }

    private boolean isXpEnabled() {
        String mode = ChestTrade.getInstance().getConfig().getString("mode", "simple");
        if ("simple".equalsIgnoreCase(mode)) {
            return false;
        }
        return ChestTrade.getInstance().getConfig().getBoolean("experience.enabled", true);
    }

    private Block getBlockFromHolder(InventoryHolder holder) {
        if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            return chest.getBlock();
        }
        if (holder instanceof Barrel) {
            Barrel barrel = (Barrel)holder;
            return barrel.getBlock();
        }
        if (holder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)holder;
            InventoryHolder inventoryHolder = doubleChest.getLeftSide();
            if (inventoryHolder instanceof Chest) {
                Chest leftChest = (Chest)inventoryHolder;
                return leftChest.getBlock();
            }
            inventoryHolder = doubleChest.getRightSide();
            if (inventoryHolder instanceof Chest) {
                Chest rightChest = (Chest)inventoryHolder;
                return rightChest.getBlock();
            }
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryOpen(InventoryOpenEvent event) {
        Block block = this.getBlockFromHolder(event.getInventory().getHolder());
        if (block == null) {
            return;
        }
        if (!TradeChestListener.isTradeChest(block)) {
            return;
        }
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            event.setCancelled(true);
            return;
        }
        Player player = (Player)humanEntity;
        UUID ownerUuid = TradeChestListener.getOwner(block);
        UUID playerUuid = DevMode.getEffectiveUUID(player);
        if (ownerUuid.equals(playerUuid)) {
            return;
        }
        if (TradeChestRegistry.getInstance().isJailed(ownerUuid)) {
            event.setCancelled(true);
            player.sendMessage(Component.text((String)"[Trade] ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"This shop is temporarily closed.", (TextColor)NamedTextColor.RED)));
            return;
        }
        this.buyersViewing.add(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        this.buyersViewing.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        UUID playerUuid;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Block block = this.getBlockFromHolder(event.getInventory().getHolder());
        if (block == null || !TradeChestListener.isTradeChest(block)) {
            return;
        }
        UUID ownerUuid = TradeChestListener.getOwner(block);
        if (ownerUuid.equals(playerUuid = DevMode.getEffectiveUUID(player))) {
            this.handleOwnerClick(event, player, block);
            return;
        }
        this.handleBuyerClick(event, player, block);
    }

    private void handleOwnerClick(InventoryClickEvent event, Player player, Block block) {
        int hotbarSlot;
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            ItemStack item;
            if (event.isShiftClick() && (item = event.getCurrentItem()) != null && !item.getType().isAir()) {
                String priceError;
                ItemStack slot0;
                int rewardSlot;
                ItemStack rewardItem;
                Inventory chestInv = event.getView().getTopInventory();
                int tier = TradeChestListener.getTier(block);
                if (this.isXpEnabled() && ((rewardItem = chestInv.getItem(rewardSlot = this.getRewardSlot(chestInv))) == null || rewardItem.getType().isAir())) {
                    boolean hasEmptySlot = false;
                    for (int i = 0; i < chestInv.getSize(); ++i) {
                        ItemStack slotItem;
                        if (i == rewardSlot || (slotItem = chestInv.getItem(i)) != null && !slotItem.getType().isAir()) continue;
                        hasEmptySlot = true;
                        break;
                    }
                    if (!hasEmptySlot) {
                        event.setCancelled(true);
                        this.sendMessage(player, "Cannot shift-click - reward slot is reserved", NamedTextColor.YELLOW);
                        return;
                    }
                }
                if (((slot0 = chestInv.getItem(0)) == null || slot0.getType().isAir()) && (priceError = ItemValidator.validatePriceSlot(item)) != null) {
                    event.setCancelled(true);
                    this.sendMessage(player, priceError, NamedTextColor.RED);
                    return;
                }
                String saleError = ItemValidator.validateSaleSlot(item, tier);
                if (saleError != null) {
                    event.setCancelled(true);
                    this.sendMessage(player, saleError, NamedTextColor.RED);
                }
            }
            return;
        }
        int slot = event.getSlot();
        int tier = TradeChestListener.getTier(block);
        InventoryAction action = event.getAction();
        Inventory chestInv = event.getView().getTopInventory();
        int rewardSlot = this.getRewardSlot(chestInv);
        if (slot == rewardSlot && this.isXpEnabled()) {
            if (action == InventoryAction.PLACE_ALL || action == InventoryAction.PLACE_SOME || action == InventoryAction.PLACE_ONE || action == InventoryAction.SWAP_WITH_CURSOR || action == InventoryAction.HOTBAR_SWAP || action == InventoryAction.HOTBAR_MOVE_AND_READD) {
                event.setCancelled(true);
                this.sendMessage(player, "Reward slot - collect books only", NamedTextColor.YELLOW);
                return;
            }
            ItemStack rewardItem = chestInv.getItem(rewardSlot);
            if (rewardItem != null && TradabilityBookItem.isTradabilityBook(rewardItem)) {
                int booksBefore = rewardItem.getAmount();
                Bukkit.getScheduler().runTaskLater((Plugin)ChestTrade.getInstance(), () -> this.processRewardPickup(player, block, booksBefore), 1L);
            }
            return;
        }
        ItemStack itemBeingPlaced = null;
        if (action == InventoryAction.PLACE_ALL || action == InventoryAction.PLACE_SOME || action == InventoryAction.PLACE_ONE || action == InventoryAction.SWAP_WITH_CURSOR) {
            itemBeingPlaced = event.getCursor();
        } else if ((action == InventoryAction.HOTBAR_SWAP || action == InventoryAction.HOTBAR_MOVE_AND_READD) && (hotbarSlot = event.getHotbarButton()) >= 0) {
            itemBeingPlaced = player.getInventory().getItem(hotbarSlot);
        }
        if (itemBeingPlaced == null || itemBeingPlaced.getType().isAir()) {
            return;
        }
        if (slot == 0) {
            String error = ItemValidator.validatePriceSlot(itemBeingPlaced);
            if (error != null) {
                event.setCancelled(true);
                this.sendMessage(player, error, NamedTextColor.RED);
            }
        } else {
            String error = ItemValidator.validateSaleSlot(itemBeingPlaced, tier);
            if (error != null) {
                event.setCancelled(true);
                this.sendMessage(player, error, NamedTextColor.RED);
            }
        }
    }

    private void handleBuyerClick(InventoryClickEvent event, Player player, Block block) {
        boolean hasCursorItem;
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            if (event.isShiftClick()) {
                event.setCancelled(true);
                this.sendMessage(player, "You cannot shift-click items into a Trade Chest", NamedTextColor.RED);
                return;
            }
            if (event.getClick() == ClickType.DOUBLE_CLICK) {
                event.setCancelled(true);
                return;
            }
            return;
        }
        int slot = event.getSlot();
        Inventory chestInv = event.getView().getTopInventory();
        if (slot == 0) {
            event.setCancelled(true);
            this.sendMessage(player, "This is the price slot - it shows what you need to pay", NamedTextColor.YELLOW);
            return;
        }
        int rewardSlot = this.getRewardSlot(chestInv);
        if (slot == rewardSlot && this.isXpEnabled()) {
            event.setCancelled(true);
            return;
        }
        ItemStack cursorItem = event.getCursor();
        boolean bl = hasCursorItem = cursorItem != null && !cursorItem.getType().isAir();
        if (hasCursorItem && event.getClick() == ClickType.LEFT) {
            this.executeTrade(event, player, block, slot);
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = chestInv.getItem(slot);
        if (clickedItem != null && !clickedItem.getType().isAir()) {
            ItemStack priceItem = chestInv.getItem(0);
            if (priceItem != null && !priceItem.getType().isAir()) {
                this.sendMessage(player, "To buy this item, pick up " + priceItem.getAmount() + "x " + this.formatMaterial(priceItem.getType()) + " from your inventory, then click the item you want to purchase.", NamedTextColor.YELLOW);
            } else {
                this.sendMessage(player, "This shop is closed (no price set in slot 1).", NamedTextColor.RED);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Block block = this.getBlockFromHolder(event.getInventory().getHolder());
        if (block == null || !TradeChestListener.isTradeChest(block)) {
            return;
        }
        UUID ownerUuid = TradeChestListener.getOwner(block);
        UUID playerUuid = DevMode.getEffectiveUUID(player);
        int invSize = event.getInventory().getSize();
        if (ownerUuid.equals(playerUuid)) {
            ItemStack draggedItem = event.getOldCursor();
            if (draggedItem == null || draggedItem.getType().isAir()) {
                return;
            }
            int tier = TradeChestListener.getTier(block);
            int rewardSlot = this.getRewardSlot(event.getInventory());
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                String error;
                int rawSlot = (Integer)iterator.next();
                if (rawSlot >= invSize) continue;
                if (rawSlot == rewardSlot && this.isXpEnabled()) {
                    event.setCancelled(true);
                    this.sendMessage(player, "Reward slot - collect books only", NamedTextColor.YELLOW);
                    return;
                }
                if (rawSlot == 0) {
                    error = ItemValidator.validatePriceSlot(draggedItem);
                    if (error == null) continue;
                    event.setCancelled(true);
                    this.sendMessage(player, error, NamedTextColor.RED);
                    return;
                }
                error = ItemValidator.validateSaleSlot(draggedItem, tier);
                if (error == null) continue;
                event.setCancelled(true);
                this.sendMessage(player, error, NamedTextColor.RED);
                return;
            }
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot >= invSize) continue;
            event.setCancelled(true);
            return;
        }
    }

    private void executeTrade(InventoryClickEvent event, Player player, Block block, int slot) {
        BlockState blockState;
        Player owner;
        event.setCancelled(true);
        Inventory chestInv = event.getView().getTopInventory();
        int rewardSlot = this.getRewardSlot(chestInv);
        if (slot == rewardSlot && this.isXpEnabled()) {
            return;
        }
        ItemStack priceItem = chestInv.getItem(0);
        if (priceItem == null || priceItem.getType().isAir()) {
            this.sendMessage(player, "This shop is closed (no price set in slot 1).", NamedTextColor.RED);
            return;
        }
        ItemStack saleItem = chestInv.getItem(slot);
        if (saleItem == null || saleItem.getType().isAir()) {
            return;
        }
        ItemStack cursorItem = event.getCursor();
        if (!this.isExactPayment(cursorItem, priceItem)) {
            if (cursorItem.getType() != priceItem.getType()) {
                this.sendMessage(player, "Wrong payment! This shop requires " + priceItem.getAmount() + "x " + this.formatMaterial(priceItem.getType()) + " as payment. You are holding " + this.formatMaterial(cursorItem.getType()) + ".", NamedTextColor.RED);
            } else {
                this.sendMessage(player, "Wrong amount! You need exactly " + priceItem.getAmount() + "x " + this.formatMaterial(priceItem.getType()) + ". You are holding " + cursorItem.getAmount() + ".", NamedTextColor.RED);
            }
            return;
        }
        chestInv.setItem(slot, cursorItem.clone());
        event.getView().setCursor(saleItem.clone());
        this.sendMessage(player, "Purchased " + saleItem.getAmount() + "x " + this.formatMaterial(saleItem.getType()) + "!", NamedTextColor.GREEN);
        UUID ownerUuid = TradeChestListener.getOwner(block);
        if (ownerUuid != null && !ownerUuid.equals(DevMode.getEffectiveUUID(player)) && (owner = Bukkit.getPlayer((UUID)ownerUuid)) != null && owner.isOnline()) {
            ToastNotification.showTradeCompleted(owner, cursorItem.getType(), cursorItem.getAmount());
        }
        if ((blockState = block.getState()) instanceof TileState) {
            int xpEarned;
            boolean isMootTrade;
            PersistentDataContainer pdc;
            TileState tileState = (TileState)blockState;
            Integer trades = (Integer)(pdc = tileState.getPersistentDataContainer()).get(TradeChestListener.KEY_TRADES, PersistentDataType.INTEGER);
            pdc.set(TradeChestListener.KEY_TRADES, PersistentDataType.INTEGER, (Object)((trades != null ? trades : 0) + 1));
            boolean bl = isMootTrade = saleItem.getType() == priceItem.getType() && saleItem.getAmount() == priceItem.getAmount();
            if (this.isXpEnabled() && !isMootTrade && (xpEarned = ItemValueTier.getXpValue(priceItem.getType())) > 0) {
                Integer currentXp = (Integer)pdc.get(TradeChestListener.KEY_XP, PersistentDataType.INTEGER);
                int xpCap = ChestTrade.getInstance().getConfig().getInt("experience.xp-cap", 1000);
                int newXp = Math.min((currentXp != null ? currentXp : 0) + xpEarned, xpCap);
                pdc.set(TradeChestListener.KEY_XP, PersistentDataType.INTEGER, (Object)newXp);
                int tier = TradeChestListener.getTier(block);
                int threshold = ItemValueTier.getXpThreshold(tier);
                if (newXp >= threshold) {
                    tileState.update();
                    this.trySpawnRewardBook(block, tier);
                    return;
                }
            }
            tileState.update();
        }
    }

    private void trySpawnRewardBook(Block block, int chestTier) {
        Player owner;
        Inventory blockInv = this.getBlockInventory(block);
        if (blockInv == null) {
            return;
        }
        int rewardSlot = this.getRewardSlot(blockInv);
        ItemStack currentItem = blockInv.getItem(rewardSlot);
        if (currentItem != null && !currentItem.getType().isAir()) {
            return;
        }
        int bookTier = ItemValueTier.getRewardBookTier(chestTier);
        ItemStack newBook = TradabilityBookItem.create(bookTier);
        blockInv.setItem(rewardSlot, newBook);
        UUID ownerUuid = TradeChestListener.getOwner(block);
        if (ownerUuid != null && (owner = Bukkit.getPlayer((UUID)ownerUuid)) != null && owner.isOnline()) {
            ToastNotification.showBookEarned(owner, bookTier);
        }
    }

    private Inventory getBlockInventory(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            return chest.getInventory();
        }
        blockState = block.getState();
        if (blockState instanceof Barrel) {
            Barrel barrel = (Barrel)blockState;
            return barrel.getInventory();
        }
        return null;
    }

    private void processRewardPickup(Player player, Block block, int booksBefore) {
        int booksTaken;
        Inventory blockInv = this.getBlockInventory(block);
        if (blockInv == null) {
            return;
        }
        int rewardSlot = this.getRewardSlot(blockInv);
        ItemStack currentItem = blockInv.getItem(rewardSlot);
        int booksNow = 0;
        if (currentItem != null && TradabilityBookItem.isTradabilityBook(currentItem)) {
            booksNow = currentItem.getAmount();
        }
        if ((booksTaken = booksBefore - booksNow) <= 0) {
            return;
        }
        int chestTier = TradeChestListener.getTier(block);
        int threshold = ItemValueTier.getXpThreshold(chestTier);
        BlockState blockState = block.getState();
        if (blockState instanceof TileState) {
            TileState tileState = (TileState)blockState;
            PersistentDataContainer pdc = tileState.getPersistentDataContainer();
            Integer currentXp = (Integer)pdc.get(TradeChestListener.KEY_XP, PersistentDataType.INTEGER);
            int xpToSubtract = threshold * booksTaken;
            int newXp = Math.max(0, (currentXp != null ? currentXp : 0) - xpToSubtract);
            pdc.set(TradeChestListener.KEY_XP, PersistentDataType.INTEGER, (Object)newXp);
            tileState.update();
            boolean mcXpEnabled = ChestTrade.getInstance().getConfig().getBoolean("experience.minecraft-xp.enabled", true);
            if (mcXpEnabled) {
                int mcXpPerBook = ChestTrade.getInstance().getConfig().getInt("experience.minecraft-xp.amount", 5);
                int totalMcXp = mcXpPerBook * booksTaken;
                if (totalMcXp > 0) {
                    Location spawnLoc = block.getLocation().add(0.5, 1.5, 0.5);
                    ExperienceOrb orb = (ExperienceOrb)player.getWorld().spawn(spawnLoc, ExperienceOrb.class);
                    orb.setExperience(totalMcXp);
                    this.sendMessage(player, "Collected " + booksTaken + " book(s)! +" + totalMcXp + " XP", NamedTextColor.GREEN);
                }
            } else {
                this.sendMessage(player, "Collected " + booksTaken + " book(s)!", NamedTextColor.GREEN);
            }
            if (booksNow == 0 && newXp >= threshold) {
                this.trySpawnRewardBook(block, chestTier);
            }
        }
    }

    private String toRoman(int tier) {
        return switch (tier) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(tier);
        };
    }

    private boolean isExactPayment(ItemStack payment, ItemStack price) {
        if (payment.getType() != price.getType()) {
            return false;
        }
        return payment.getAmount() == price.getAmount();
    }

    private void sendMessage(Player player, String message, NamedTextColor color) {
        player.sendMessage(Component.text((String)"[Trade] ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)message, (TextColor)color)));
    }

    private String formatMaterial(Material material) {
        String name = material.name().toLowerCase().replace('_', ' ');
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                result.append(c);
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

