/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.chesttrade.util;

import com.elfahja.chesttrade.ChestTrade;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;

public class ItemValueTier {
    private static final Set<Material> TIER_COMMON = EnumSet.of(Material.DIRT, new Material[]{Material.COARSE_DIRT, Material.ROOTED_DIRT, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE, Material.COBBLED_DEEPSLATE, Material.GRAVEL, Material.SAND, Material.RED_SAND, Material.NETHERRACK, Material.STONE, Material.DEEPSLATE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.TUFF, Material.MUD, Material.CLAY_BALL, Material.CLAY});
    private static final Set<Material> TIER_BASIC = EnumSet.of(Material.COAL, new Material[]{Material.CHARCOAL, Material.COPPER_INGOT, Material.RAW_COPPER, Material.RAW_IRON, Material.RAW_GOLD, Material.LEATHER, Material.STICK});
    private static final Set<Material> TIER_USEFUL = EnumSet.of(Material.IRON_INGOT, new Material[]{Material.REDSTONE, Material.LAPIS_LAZULI, Material.BONE, Material.GUNPOWDER, Material.STRING, Material.FEATHER, Material.PAPER, Material.BOOK, Material.INK_SAC, Material.GLOW_INK_SAC});
    private static final Set<Material> TIER_VALUABLE = EnumSet.of(Material.GOLD_INGOT, new Material[]{Material.QUARTZ, Material.PRISMARINE_SHARD, Material.PRISMARINE_CRYSTALS, Material.HONEY_BOTTLE, Material.SLIME_BALL, Material.MAGMA_CREAM, Material.BLAZE_ROD, Material.BLAZE_POWDER, Material.ENDER_PEARL, Material.GHAST_TEAR, Material.PHANTOM_MEMBRANE, Material.NAUTILUS_SHELL, Material.RABBIT_FOOT});
    private static final Set<Material> TIER_PRECIOUS = EnumSet.of(Material.DIAMOND, new Material[]{Material.EMERALD, Material.AMETHYST_SHARD, Material.ECHO_SHARD, Material.SHULKER_SHELL, Material.WITHER_SKELETON_SKULL});
    private static final Set<Material> TIER_RARE = EnumSet.of(Material.NETHERITE_INGOT, new Material[]{Material.NETHERITE_SCRAP, Material.ANCIENT_DEBRIS, Material.NETHER_STAR, Material.HEART_OF_THE_SEA, Material.TOTEM_OF_UNDYING, Material.DRAGON_BREATH, Material.DRAGON_EGG, Material.ELYTRA});

    public static int getXpValue(Material material) {
        String tierName = ItemValueTier.getTierName(material);
        return ChestTrade.getInstance().getConfig().getInt("experience.xp-per-item-tier." + tierName, ItemValueTier.getDefaultXp(tierName));
    }

    private static String getTierName(Material material) {
        if (TIER_RARE.contains(material)) {
            return "rare";
        }
        if (TIER_PRECIOUS.contains(material)) {
            return "precious";
        }
        if (TIER_VALUABLE.contains(material)) {
            return "valuable";
        }
        if (TIER_USEFUL.contains(material)) {
            return "useful";
        }
        if (TIER_COMMON.contains(material)) {
            return "common";
        }
        if (TIER_BASIC.contains(material)) {
            return "basic";
        }
        if (material.name().endsWith("_LOG") || material.name().endsWith("_WOOD")) {
            return "basic";
        }
        if (material.name().endsWith("_PLANKS")) {
            return "basic";
        }
        if (material.name().endsWith("_WOOL")) {
            return "basic";
        }
        return "basic";
    }

    private static int getDefaultXp(String tierName) {
        return switch (tierName) {
            case "common" -> 0;
            case "basic" -> 1;
            case "useful" -> 2;
            case "valuable" -> 5;
            case "precious" -> 10;
            case "rare" -> 25;
            default -> 1;
        };
    }

    public static int getXpThreshold(int currentTier) {
        int defaultThreshold = switch (currentTier) {
            case 1 -> 25;
            case 2 -> 50;
            case 3 -> 100;
            case 4, 5 -> 150;
            default -> 150;
        };
        return ChestTrade.getInstance().getConfig().getInt("experience.xp-threshold.tier-" + currentTier, defaultThreshold);
    }

    public static int getRewardBookTier(int currentTier) {
        return Math.min(currentTier + 1, 5);
    }
}

